// Copyright (C) 2023, Gurobi Optimization, LLC
// All Rights Reserved
#ifndef _CPP_ATTRPRIVATE_H_
#define _CPP_ATTRPRIVATE_H_

// orders need to match enums in public.h

static const char* iattrname[] = {
  "NumConstrs",
  "NumVars",
  "NumSOS",
  "NumQConstrs",
  "NumGenConstrs",
  "NumNZs",
  "NumQNZs",
  "NumQCNZs",
  "NumIntVars",
  "NumBinVars",
  "NumPWLObjVars",
  "ModelSense",
  "IsMIP",
  "IsQP",
  "IsQCP",
  "IsMultiObj",
  "Status",
  "ConcurrentWinMethod",
  "SolCount",
  "BarIterCount",
  "VBasis",
  "CBasis",
  "PWLObjCvx",
  "BranchPriority",
  "VarPreStat",
  "BoundVioIndex",
  "BoundSVioIndex",
  "ConstrVioIndex",
  "ConstrSVioIndex",
  "ConstrResidualIndex",
  "ConstrSResidualIndex",
  "DualVioIndex",
  "DualSVioIndex",
  "DualResidualIndex",
  "DualSResidualIndex",
  "ComplVioIndex",
  "IntVioIndex",
  "IISMinimal",
  "IISLB",
  "IISUB",
  "IISConstr",
  "IISSOS",
  "IISQConstr",
  "IISGenConstr",
  "IISLBForce",
  "IISUBForce",
  "IISConstrForce",
  "IISSOSForce",
  "IISQConstrForce",
  "IISGenConstrForce",
  "TuneResultCount",
  "Lazy",
  "VarHintPri",
  "ObjNPriority",
  "NumObj",
  "GenConstrType",
  "NumStart",
  "Partition",
  "LicenseExpiration",
  "NumScenarios",
  "FuncPieces",
  "BatchErrorCode",
  "BatchStatus",
  "Fingerprint",
  "PoolIgnore"
};

static const char* cattrname[] = {
  "VType",
  "Sense",
  "QCSense"
};

static const char* dattrname[] = {
  "Runtime",
  "Work",
  "ObjCon",
  "LB",
  "UB",
  "Obj",
  "Start",
  "PreFixVal",
  "RHS",
  "QCRHS",
  "MaxCoeff",
  "MinCoeff",
  "MaxBound",
  "MinBound",
  "MaxObjCoeff",
  "MinObjCoeff",
  "MaxRHS",
  "MinRHS",
  "MaxQCRHS",
  "MinQCRHS",
  "MaxQCCoeff",
  "MinQCCoeff",
  "MaxQCLCoeff",
  "MinQCLCoeff",
  "MaxQObjCoeff",
  "MinQObjCoeff",
  "ObjVal",
  "ObjBound",
  "ObjBoundC",
  "MIPGap",
  "IterCount",
  "NodeCount",
  "X",
  "RC",
  "Pi",
  "QCPi",
  "Slack",
  "QCSlack",
  "MaxVio",
  "BoundVio",
  "BoundSVio",
  "BoundVioSum",
  "BoundSVioSum",
  "ConstrVio",
  "ConstrSVio",
  "ConstrVioSum",
  "ConstrSVioSum",
  "ConstrResidual",
  "ConstrSResidual",
  "ConstrResidualSum",
  "ConstrSResidualSum",
  "DualVio",
  "DualSVio",
  "DualVioSum",
  "DualSVioSum",
  "DualResidual",
  "DualSResidual",
  "DualResidualSum",
  "DualSResidualSum",
  "ComplVio",
  "ComplVioSum",
  "IntVio",
  "IntVioSum",
  "Kappa",
  "KappaExact",
  "SAObjLow",
  "SAObjUp",
  "SALBLow",
  "SALBUp",
  "SARHSLow",
  "SAUBLow",
  "SAUBUp",
  "SARHSUp",
  "Xn",
  "FarkasProof",
  "FarkasDual",
  "UnbdRay",
  "PStart",
  "DStart",
  "BarX",
  "VarHintVal",
  "ObjN",
  "ObjNCon",
  "ObjNWeight",
  "ObjNRelTol",
  "ObjNAbsTol",
  "ObjNVal",
  "OpenNodeCount",
  "PoolObjBound",
  "PoolObjVal",
  "ScenNLB",
  "ScenNUB",
  "ScenNObj",
  "ScenNRHS",
  "ScenNX",
  "ScenNObjBound",
  "ScenNObjVal",
  "FuncPieceError",
  "FuncPieceLength",
  "FuncPieceRatio",
  "DNumNZs"
};

static const char* sattrname[] = {
  "ModelName",
  "VarName",
  "ConstrName",
  "QCName",
  "GenConstrName",
  "ObjNName",
  "ScenNName",
  "BatchID",
  "VTag",
  "CTag",
  "QCTag",
  "BatchErrorMessage"
};

void checkattrsize(GRBmodel *Cmodel, const char *attrname, int size);
#endif
