/*
 * Decompiled with CFR 0.152.
 */
package gurobi;

import gurobi.GRB;
import gurobi.GRBCObj;
import gurobi.GRBException;
import gurobi.GurobiJni;

public class GRBVar {
    private GRBCObj Cmodel = null;
    private long model;
    private int col_no;

    GRBVar() {
        this.col_no = -2;
        this.model = 0L;
    }

    GRBVar(GRBCObj XCmodel, int col) {
        this.Cmodel = XCmodel;
        this.model = XCmodel.get();
        this.col_no = col;
    }

    void setcolno(int col) {
        this.col_no = col;
    }

    int getcolno() {
        return this.col_no;
    }

    protected void finalize() {
    }

    public boolean sameAs(GRBVar otherVar) {
        return this.model == otherVar.model && this.col_no == otherVar.col_no;
    }

    public int index() {
        return this.getcolno();
    }

    public int get(GRB.IntAttr attr) throws GRBException {
        if (this.col_no < 0 || this.model == 0L) {
            throw new GRBException(20001);
        }
        int error = GRB.checkattrsize(this.model, attr.toString(), 1);
        if (error != 0) {
            throw new GRBException("Not variable attribute", error);
        }
        int[] ind = new int[1];
        int[] value = new int[1];
        error = GurobiJni.getintattrlist(this.model, attr.toString(), this.col_no, 0, ind, value);
        if (error != 0) {
            throw new GRBException("Error at GRBVar.get", error);
        }
        return value[0];
    }

    public char get(GRB.CharAttr attr) throws GRBException {
        if (this.col_no < 0 || this.model == 0L) {
            throw new GRBException(20001);
        }
        int error = GRB.checkattrsize(this.model, attr.toString(), 1);
        if (error != 0) {
            throw new GRBException("Not variable attribute", error);
        }
        int[] ind = new int[1];
        char[] value = new char[1];
        error = GurobiJni.getcharattrlist(this.model, attr.toString(), this.col_no, 0, ind, value);
        if (error != 0) {
            throw new GRBException("Error at GRBVar.get", error);
        }
        return value[0];
    }

    public double get(GRB.DoubleAttr attr) throws GRBException {
        if (this.col_no < 0 || this.model == 0L) {
            throw new GRBException(20001);
        }
        int error = GRB.checkattrsize(this.model, attr.toString(), 1);
        if (error != 0) {
            throw new GRBException("Not variable attribute", error);
        }
        int[] ind = new int[1];
        double[] value = new double[1];
        error = GurobiJni.getdblattrlist(this.model, attr.toString(), this.col_no, 0, ind, value);
        if (error != 0) {
            throw new GRBException("Error at GRBVar.get", error);
        }
        return value[0];
    }

    public String get(GRB.StringAttr attr) throws GRBException {
        if (this.col_no < 0 || this.model == 0L) {
            throw new GRBException(20001);
        }
        int error = GRB.checkattrsize(this.model, attr.toString(), 1);
        if (error != 0) {
            throw new GRBException("Not variable attribute", error);
        }
        int[] ind = new int[1];
        String[] value = new String[1];
        error = GurobiJni.getstrattrlist(this.model, attr.toString(), this.col_no, 0, ind, value);
        if (error != 0) {
            throw new GRBException("Error at GRBVar.get", error);
        }
        return value[0];
    }

    public void set(GRB.IntAttr attr, int newval) throws GRBException {
        if (this.col_no < 0 || this.model == 0L) {
            throw new GRBException(20001);
        }
        int error = GRB.checkattrsize(this.model, attr.toString(), 1);
        if (error != 0) {
            throw new GRBException("Not variable attribute", error);
        }
        int[] ind = new int[1];
        int[] tmp = new int[]{newval};
        error = GurobiJni.setintattrlist(this.model, attr.toString(), this.col_no, 0, ind, tmp);
        if (error != 0) {
            throw new GRBException("Error at GRBVar.set", error);
        }
    }

    public void set(GRB.CharAttr attr, char newval) throws GRBException {
        if (this.col_no < 0 || this.model == 0L) {
            throw new GRBException(20001);
        }
        int error = GRB.checkattrsize(this.model, attr.toString(), 1);
        if (error != 0) {
            throw new GRBException("Not variable attribute", error);
        }
        int[] ind = new int[1];
        char[] tmp = new char[]{newval};
        error = GurobiJni.setcharattrlist(this.model, attr.toString(), this.col_no, 0, ind, tmp);
        if (error != 0) {
            throw new GRBException("Error at GRBVar.set", error);
        }
    }

    public void set(GRB.DoubleAttr attr, double newval) throws GRBException {
        if (this.col_no < 0 || this.model == 0L) {
            throw new GRBException(20001);
        }
        int error = GRB.checkattrsize(this.model, attr.toString(), 1);
        if (error != 0) {
            throw new GRBException("Not variable attribute", error);
        }
        int[] ind = new int[1];
        double[] tmp = new double[]{newval};
        error = GurobiJni.setdblattrlist(this.model, attr.toString(), this.col_no, 0, ind, tmp);
        if (error != 0) {
            throw new GRBException("Error at GRBVar.set", error);
        }
    }

    public void set(GRB.StringAttr attr, String newval) throws GRBException {
        if (this.col_no < 0 || this.model == 0L) {
            throw new GRBException(20001);
        }
        int error = GRB.checkattrsize(this.model, attr.toString(), 1);
        if (error != 0) {
            throw new GRBException("Not variable attribute", error);
        }
        int[] ind = new int[1];
        String[] tmp = new String[]{newval};
        error = GurobiJni.setstrattrlist(this.model, attr.toString(), this.col_no, 0, ind, tmp);
        if (error != 0) {
            throw new GRBException("Error at GRBVar.set", error);
        }
    }
}

