/*
 * Decompiled with CFR 0.152.
 */
package gurobi;

import gurobi.GRB;
import gurobi.GRBCObj;
import gurobi.GRBCallback;
import gurobi.GRBColumn;
import gurobi.GRBConstr;
import gurobi.GRBEnv;
import gurobi.GRBException;
import gurobi.GRBExpr;
import gurobi.GRBGenConstr;
import gurobi.GRBLinExpr;
import gurobi.GRBQConstr;
import gurobi.GRBQuadExpr;
import gurobi.GRBSOS;
import gurobi.GRBVar;
import gurobi.GurobiJni;
import java.util.ArrayList;
import java.util.function.Consumer;

public class GRBModel {
    private static final double RANGEBD = 1.0E25;
    private GRBCallback cb = null;
    private GRBEnv genv = null;
    private GRBCObj Cmodel = null;
    private long env = 0L;
    private long model = 0L;
    private long cbdata = 0L;
    private long jcbdata = 0L;
    private int where = 0;
    private int cols = 0;
    private int rows = 0;
    private int numsos = 0;
    private int numqconstrs = 0;
    private int numgenconstrs = 0;
    private int newranges = 0;
    private int isfreed = 0;
    private int updatemode = -1;
    private ArrayList<GRBVar> vars;
    private ArrayList<GRBConstr> constrs;
    private ArrayList<GRBSOS> sos;
    private ArrayList<GRBQConstr> qconstrs;
    private ArrayList<GRBGenConstr> genconstrs;

    GRBModel() {
        this.vars = new ArrayList();
        this.constrs = new ArrayList();
        this.sos = new ArrayList();
        this.qconstrs = new ArrayList();
        this.genconstrs = new ArrayList();
    }

    public GRBModel(GRBEnv env) throws GRBException {
        this.genv = env;
        this.env = env.get();
        int[] error = new int[1];
        this.model = GurobiJni.newmodel(error, this.env, null, 0, null, null, null, null, null);
        if (error[0] != 0 || this.model == 0L) {
            throw new GRBException("Failed to create model", error[0]);
        }
        this.env = GurobiJni.getenv(this.model);
        this.populate(true);
        this.genv.modelCntIncrease();
    }

    public GRBModel(GRBEnv env, String filename) throws GRBException {
        this.genv = env;
        this.env = env.get();
        this.model = GurobiJni.readmodel(this.env, filename);
        if (this.model == 0L) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), 10012);
        }
        this.env = GurobiJni.getenv(this.model);
        this.populate(false);
        this.genv.modelCntIncrease();
    }

    public GRBModel(GRBModel model) throws GRBException {
        this.model = GurobiJni.copymodel(model.model);
        if (this.model == 0L) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), 20002);
        }
        this.genv = model.genv;
        this.env = GurobiJni.getenv(this.model);
        this.populate(false);
        this.genv.modelCntIncrease();
    }

    long get() {
        return this.model;
    }

    void populate(boolean emptyModel) throws GRBException {
        int i;
        if (this.Cmodel == null) {
            this.Cmodel = new GRBCObj(this.model, 1);
        }
        if (emptyModel) {
            this.numgenconstrs = 0;
            this.numqconstrs = 0;
            this.numsos = 0;
            this.rows = 0;
            this.cols = 0;
        } else {
            this.prefetchAttr(GRB.IntAttr.NumVars);
            this.prefetchAttr(GRB.IntAttr.NumConstrs);
            this.prefetchAttr(GRB.IntAttr.NumSOS);
            this.prefetchAttr(GRB.IntAttr.NumQConstrs);
            this.prefetchAttr(GRB.IntAttr.NumGenConstrs);
            this.cols = this.get(GRB.IntAttr.NumVars);
            this.rows = this.get(GRB.IntAttr.NumConstrs);
            this.numsos = this.get(GRB.IntAttr.NumSOS);
            this.numqconstrs = this.get(GRB.IntAttr.NumQConstrs);
            this.numgenconstrs = this.get(GRB.IntAttr.NumGenConstrs);
        }
        this.vars = new ArrayList(this.cols);
        this.constrs = new ArrayList(this.rows);
        this.sos = new ArrayList(this.numsos);
        this.qconstrs = new ArrayList(this.numqconstrs);
        this.genconstrs = new ArrayList(this.numgenconstrs);
        for (i = 0; i < this.cols; ++i) {
            this.vars.add(new GRBVar(this.Cmodel, i));
        }
        for (i = 0; i < this.rows; ++i) {
            this.constrs.add(new GRBConstr(this.Cmodel, i));
        }
        for (i = 0; i < this.numsos; ++i) {
            this.sos.add(new GRBSOS(this.Cmodel, i));
        }
        for (i = 0; i < this.numqconstrs; ++i) {
            this.qconstrs.add(new GRBQConstr(this.Cmodel, i));
        }
        for (i = 0; i < this.numgenconstrs; ++i) {
            this.genconstrs.add(new GRBGenConstr(this.Cmodel, i));
        }
    }

    public void dispose() {
        if (this.isfreed == 0) {
            this.isfreed = 1;
            this.Cmodel.dispose();
            this.genv.modelCntDecrease();
        }
    }

    protected void finalize() {
        if (this.isfreed == 0) {
            this.isfreed = 1;
            this.Cmodel.dispose();
            this.genv.modelCntDecrease();
        }
    }

    public void read(String filename) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int error = GurobiJni.read(this.model, filename);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void write(String filename) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int rtcode1 = GurobiJni.ismodelfile(filename);
        int rtcode2 = GurobiJni.isattrfile(filename);
        assert (rtcode1 != 1 || rtcode2 != 1);
        if (rtcode1 == 1 && rtcode2 == 0 || rtcode1 == 0 && rtcode2 == 1) {
            this.update();
        } else {
            if (rtcode1 != 0 && rtcode1 != 1) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), rtcode1);
            }
            if (rtcode2 != 0 && rtcode2 != 1) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), rtcode2);
            }
        }
        int error = GurobiJni.write(this.model, filename);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void sync() throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        String[] errormsg = new String[1];
        int error = GurobiJni.sync(this.model, this.jcbdata, errormsg);
        if (error != 10017) {
            this.jcbdata = 0L;
        }
        if (error != 0) {
            throw new GRBException(errormsg[0], error);
        }
    }

    public GRBModel relax() throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        long[] relaxed = new long[1];
        int error = GurobiJni.relaxmodel(this.model, relaxed);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (relaxed[0] == 0L) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), 20002);
        }
        GRBModel newmodel = new GRBModel();
        newmodel.genv = this.genv;
        newmodel.env = GurobiJni.getenv(relaxed[0]);
        newmodel.model = relaxed[0];
        newmodel.populate(false);
        newmodel.genv.modelCntIncrease();
        return newmodel;
    }

    public GRBModel fixedModel() throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        long[] fixed = new long[1];
        int error = GurobiJni.fixedmodel(this.model, fixed);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (fixed[0] == 0L) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), 20002);
        }
        GRBModel newmodel = new GRBModel();
        newmodel.genv = this.genv;
        newmodel.env = GurobiJni.getenv(fixed[0]);
        newmodel.model = fixed[0];
        newmodel.populate(false);
        newmodel.genv.modelCntIncrease();
        return newmodel;
    }

    public GRBModel presolve() throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        this.update();
        long[] presolved = new long[1];
        int error = GurobiJni.presolvemodel(this.model, presolved);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (presolved[0] == 0L) {
            throw new GRBException("Unable to create presolved model", 20002);
        }
        GRBModel newmodel = new GRBModel();
        newmodel.genv = this.genv;
        newmodel.env = GurobiJni.getenv(presolved[0]);
        newmodel.model = presolved[0];
        newmodel.populate(false);
        newmodel.genv.modelCntIncrease();
        return newmodel;
    }

    public GRBModel dualize() throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        this.update();
        long[] dual = new long[1];
        int error = GurobiJni.dualmodel(this.model, dual);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (dual[0] == 0L) {
            throw new GRBException("Unable to create dual model", 20002);
        }
        GRBModel newmodel = new GRBModel();
        newmodel.genv = this.genv;
        newmodel.env = GurobiJni.getenv(dual[0]);
        newmodel.model = dual[0];
        newmodel.populate(false);
        newmodel.genv.modelCntIncrease();
        return newmodel;
    }

    public GRBModel feasibility() throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        long[] feas = new long[1];
        int error = GurobiJni.feasibility(this.model, feas);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (feas[0] == 0L) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), 20002);
        }
        GRBModel newmodel = new GRBModel();
        newmodel.genv = this.genv;
        newmodel.env = GurobiJni.getenv(feas[0]);
        newmodel.model = feas[0];
        newmodel.populate(false);
        newmodel.genv.modelCntIncrease();
        return newmodel;
    }

    public GRBModel linearize() throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        long[] linearized = new long[1];
        int error = GurobiJni.linearize(this.model, linearized);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (linearized[0] == 0L) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), 20002);
        }
        GRBModel newmodel = new GRBModel();
        newmodel.genv = this.genv;
        newmodel.env = GurobiJni.getenv(linearized[0]);
        newmodel.model = linearized[0];
        newmodel.populate(false);
        newmodel.genv.modelCntIncrease();
        return newmodel;
    }

    public GRBModel singleScenarioModel() throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        long[] singlescenario = new long[1];
        int error = GurobiJni.singlescenariomodel(this.model, singlescenario);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (singlescenario[0] == 0L) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), 20002);
        }
        GRBModel newmodel = new GRBModel();
        newmodel.genv = this.genv;
        newmodel.env = GurobiJni.getenv(singlescenario[0]);
        newmodel.model = singlescenario[0];
        newmodel.populate(false);
        newmodel.genv.modelCntIncrease();
        return newmodel;
    }

    public double feasRelax(int relaxobjtype, boolean minrelax, boolean vrelax, boolean crelax) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        this.update();
        if (relaxobjtype < 0 || relaxobjtype > 2) {
            throw new GRBException("Invalid arguments", 10003);
        }
        int vlen = vrelax ? -1 : 0;
        int clen = crelax ? -1 : 0;
        if (vlen != 0 || clen != 0) {
            return this.feasRelaxP(relaxobjtype, minrelax, vlen, clen, null, null, null, null, null);
        }
        return 0.0;
    }

    public double feasRelax(int relaxobjtype, boolean minrelax, GRBVar[] vars, double[] lbpen, double[] ubpen, GRBConstr[] constrs, double[] rhspen) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        this.update();
        if (relaxobjtype < 0 || relaxobjtype > 2) {
            throw new GRBException("Invalid arguments", 10003);
        }
        int vlen = this.cols;
        int clen = this.rows;
        if (vars != null) {
            if (vars.length < vlen) {
                vlen = vars.length;
            }
        } else {
            vlen = 0;
        }
        if (constrs != null) {
            if (constrs.length < clen) {
                clen = constrs.length;
            }
        } else {
            clen = 0;
        }
        return this.feasRelaxP(relaxobjtype, minrelax, vlen, clen, vars, lbpen, ubpen, constrs, rhspen);
    }

    private double feasRelaxP(int relaxobjtype, boolean xminrelax, int vlen, int clen, GRBVar[] xvars, double[] lbpen, double[] ubpen, GRBConstr[] xconstrs, double[] rhspen) throws GRBException {
        double[] feasobj;
        int error;
        int i;
        int minrelax;
        double[] prhs;
        double[] pub;
        double[] plb;
        block20: {
            int k;
            block18: {
                int j;
                plb = null;
                pub = null;
                prhs = null;
                minrelax = xminrelax ? 1 : 0;
                if (vlen == 0) break block18;
                plb = new double[this.cols];
                pub = new double[this.cols];
                if (vlen > 0) {
                    for (j = 0; j < this.cols; ++j) {
                        plb[j] = 1.0E100;
                        pub[j] = 1.0E100;
                    }
                } else {
                    for (j = 0; j < this.cols; ++j) {
                        plb[j] = 1.0;
                        pub[j] = 1.0;
                    }
                }
                for (k = 0; k < vlen; ++k) {
                    j = xvars[k].getcolno();
                    if (j < 0 || j >= this.cols) {
                        throw new GRBException("Variable not in model", 20001);
                    }
                    if (k < lbpen.length) {
                        plb[j] = lbpen[k];
                    }
                    if (k >= ubpen.length) continue;
                    pub[j] = ubpen[k];
                }
            }
            if (clen == 0) break block20;
            prhs = new double[this.rows];
            if (clen > 0) {
                for (i = 0; i < this.rows; ++i) {
                    prhs[i] = 1.0E100;
                }
            } else {
                for (i = 0; i < this.rows; ++i) {
                    prhs[i] = 1.0;
                }
            }
            for (k = 0; k < clen; ++k) {
                i = xconstrs[k].getrowno();
                if (i < 0 || i >= this.rows) {
                    throw new GRBException("Constraint not in model", 20001);
                }
                if (k >= rhspen.length) continue;
                prhs[i] = rhspen[k];
            }
        }
        if ((error = GurobiJni.feasrelax(this.model, relaxobjtype, minrelax, plb, pub, prhs, feasobj = new double[1])) != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        this.prefetchAttr(GRB.IntAttr.NumVars);
        this.prefetchAttr(GRB.IntAttr.NumConstrs);
        this.prefetchAttr(GRB.IntAttr.NumQConstrs);
        this.prefetchAttr(GRB.IntAttr.NumGenConstrs);
        int xcols = this.get(GRB.IntAttr.NumVars);
        int xrows = this.get(GRB.IntAttr.NumConstrs);
        int xnumqconstrs = this.get(GRB.IntAttr.NumQConstrs);
        int xnumgenconstrs = this.get(GRB.IntAttr.NumGenConstrs);
        for (i = this.cols; i < xcols; ++i) {
            this.vars.add(new GRBVar(this.Cmodel, i));
        }
        for (i = this.rows; i < xcols; ++i) {
            this.constrs.add(new GRBConstr(this.Cmodel, i));
        }
        for (i = this.numqconstrs; i < xnumqconstrs; ++i) {
            this.qconstrs.add(new GRBQConstr(this.Cmodel, i));
        }
        for (i = this.numgenconstrs; i < xnumgenconstrs; ++i) {
            this.genconstrs.add(new GRBGenConstr(this.Cmodel, i));
        }
        this.cols = xcols;
        this.rows = xrows;
        this.numqconstrs = xnumqconstrs;
        this.numgenconstrs = xnumgenconstrs;
        return feasobj[0];
    }

    public GRBVar getVar(int i) {
        if (i < 0 || i >= this.cols) {
            return null;
        }
        return this.vars.get(i);
    }

    public GRBVar[] getVars() {
        GRBVar[] xvars = new GRBVar[this.cols];
        for (int i = 0; i < this.cols; ++i) {
            xvars[i] = this.vars.get(i);
        }
        return xvars;
    }

    public GRBVar getVarByName(String name) throws GRBException {
        int[] index = new int[]{-1};
        int error = GurobiJni.getvarbyname(this.model, name, index);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (index[0] < 0) {
            return null;
        }
        return this.vars.get(index[0]);
    }

    public GRBConstr getConstr(int i) {
        if (i < 0 || i >= this.rows) {
            return null;
        }
        return this.constrs.get(i);
    }

    public GRBConstr[] getConstrs() {
        GRBConstr[] xconstrs = new GRBConstr[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            xconstrs[i] = this.constrs.get(i);
        }
        return xconstrs;
    }

    public GRBConstr getConstrByName(String name) throws GRBException {
        int[] index = new int[]{-1};
        int error = GurobiJni.getconstrbyname(this.model, name, index);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (index[0] < 0) {
            return null;
        }
        return this.constrs.get(index[0]);
    }

    public GRBSOS[] getSOSs() {
        GRBSOS[] xsoss = new GRBSOS[this.numsos];
        for (int i = 0; i < this.numsos; ++i) {
            xsoss[i] = this.sos.get(i);
        }
        return xsoss;
    }

    public GRBQConstr[] getQConstrs() {
        GRBQConstr[] xqconstrs = new GRBQConstr[this.numqconstrs];
        for (int i = 0; i < this.numqconstrs; ++i) {
            xqconstrs[i] = this.qconstrs.get(i);
        }
        return xqconstrs;
    }

    public GRBGenConstr[] getGenConstrs() {
        GRBGenConstr[] xgenconstrs = new GRBGenConstr[this.numgenconstrs];
        for (int i = 0; i < this.numgenconstrs; ++i) {
            xgenconstrs[i] = this.genconstrs.get(i);
        }
        return xgenconstrs;
    }

    public GRBExpr getObjective() throws GRBException {
        int[] jind = new int[1];
        int[] jqnz = new int[1];
        int[] jcols = new int[1];
        double[] jobjcon = new double[1];
        int error = GurobiJni.getintattrlist(this.model, "NumVars", 0, -1, jind, jcols);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        int cols = jcols[0];
        error = GurobiJni.getdblattrlist(this.model, "ObjCon", 0, -1, jind, jobjcon);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        double objcon = jobjcon[0];
        double[] obj = new double[cols];
        if (cols > 0) {
            error = GurobiJni.getdblattrlist(this.model, "Obj", 0, cols, null, obj);
        }
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBLinExpr le = new GRBLinExpr();
        le.addConstant(objcon);
        for (int i = 0; i < cols; ++i) {
            if (obj[i] == 0.0) continue;
            le.addTerm(obj[i], this.vars.get(i));
        }
        error = GurobiJni.getintattrlist(this.model, "NumQNZs", 0, -1, jind, jqnz);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        int qnz = jqnz[0];
        if (qnz > 0) {
            GRBQuadExpr qe = new GRBQuadExpr(le);
            int[] qrow = new int[qnz];
            int[] qcol = new int[qnz];
            double[] qval = new double[qnz];
            error = GurobiJni.getq(this.model, jqnz, qrow, qcol, qval);
            if (error != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error);
            }
            for (int i = 0; i < qnz; ++i) {
                qe.addTerm(qval[i], this.vars.get(qrow[i]), this.vars.get(qcol[i]));
            }
            return qe;
        }
        return le;
    }

    public GRBLinExpr getObjective(int index) throws GRBException {
        int[] objnumber = new int[1];
        int[] jind = new int[1];
        int[] jqnz = new int[1];
        int[] jcols = new int[1];
        double[] jobjcon = new double[1];
        int error = GurobiJni.getintparam(this.env, "ObjNumber", objnumber);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        error = GurobiJni.setintparam(this.env, "ObjNumber", index);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        error = GurobiJni.getintattrlist(this.model, "NumVars", 0, -1, jind, jcols);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        int cols = jcols[0];
        error = GurobiJni.getdblattrlist(this.model, "ObjNCon", 0, -1, jind, jobjcon);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        double objcon = jobjcon[0];
        double[] obj = new double[cols];
        if (cols > 0) {
            error = GurobiJni.getdblattrlist(this.model, "ObjN", 0, cols, null, obj);
        }
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        error = GurobiJni.setintparam(this.env, "ObjNumber", objnumber[0]);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBLinExpr le = new GRBLinExpr();
        le.addConstant(objcon);
        for (int i = 0; i < cols; ++i) {
            if (obj[i] == 0.0) continue;
            le.addTerm(obj[i], this.vars.get(i));
        }
        if (index == 0) {
            error = GurobiJni.getintattrlist(this.model, "NumQNZs", 0, -1, jind, jqnz);
            if (error != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error);
            }
            int qnz = jqnz[0];
            if (qnz > 0) {
                throw new GRBException("Objective is quadratic", 10005);
            }
        }
        return le;
    }

    public int getPWLObj(GRBVar var, double[] x, double[] y) throws GRBException {
        int error = 0;
        int col = var.getcolno();
        if (col < 0 || col >= this.cols) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] pts = new int[]{0};
        error = GurobiJni.getpwlobj(this.model, col, pts, null, null);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (x == null || y == null) {
            return pts[0];
        }
        if (x.length < pts[0] || y.length < pts[0]) {
            throw new GRBException("Array too short", 10003);
        }
        error = GurobiJni.getpwlobj(this.model, col, pts, x, y);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return pts[0];
    }

    public void setObjective(GRBExpr expr) throws GRBException {
        this.setObjective(expr, 0);
    }

    public void setObjective(GRBExpr expr, int sense) throws GRBException {
        int i;
        int[] jind = new int[1];
        int[] jqnz = new int[1];
        double[] jobjcon = new double[1];
        int error = 0;
        error = GurobiJni.delq(this.model);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        int tcols = this.getupdmode() == 1 ? this.vars.size() : this.cols;
        GRBLinExpr le = expr instanceof GRBQuadExpr ? ((GRBQuadExpr)expr).getLinExpr() : (GRBLinExpr)expr;
        double[] obj = new double[tcols];
        for (i = 0; i < tcols; ++i) {
            obj[i] = 0.0;
        }
        for (i = 0; i < le.size(); ++i) {
            int j = le.getVar(i).getcolno();
            if (j < 0) {
                throw new GRBException("Variable not in model", 20001);
            }
            int n = j;
            obj[n] = obj[n] + le.getCoeff(i);
        }
        if (tcols > 0) {
            error = GurobiJni.setdblattrlist(this.model, "Obj", 0, tcols, null, obj);
        }
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        jobjcon[0] = le.getConstant();
        error = GurobiJni.setdblattrlist(this.model, "ObjCon", 0, -1, jind, jobjcon);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (sense != 0) {
            jind[0] = sense;
            error = GurobiJni.setintattrlist(this.model, "ModelSense", 0, -1, jind, jind);
            if (error != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error);
            }
        }
        if (expr instanceof GRBQuadExpr) {
            GRBQuadExpr qe = (GRBQuadExpr)expr;
            int qnz = qe.size();
            int[] qrow = new int[qnz];
            int[] qcol = new int[qnz];
            double[] qval = new double[qnz];
            for (int i2 = 0; i2 < qnz; ++i2) {
                qrow[i2] = qe.getVar1(i2).getcolno();
                qcol[i2] = qe.getVar2(i2).getcolno();
                if (qrow[i2] < 0 || qcol[i2] < 0) {
                    throw new GRBException("Variable not in model", 20001);
                }
                qval[i2] = qe.getCoeff(i2);
            }
            error = GurobiJni.addqpterms(this.model, qnz, qrow, qcol, qval);
            if (error != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error);
            }
        }
    }

    public void setObjectiveN(GRBLinExpr expr, int index, int priority, double weight, double abstol, double reltol, String name) throws GRBException {
        int len = expr.size();
        int[] ind = new int[len];
        double[] val = new double[len];
        int error = 0;
        double objcon = expr.getConstant();
        for (int i = 0; i < len; ++i) {
            ind[i] = expr.getVar(i).getcolno();
            val[i] = expr.getCoeff(i);
            if (ind[i] >= 0) continue;
            throw new GRBException("Variable not in model", 20001);
        }
        error = GurobiJni.setobjectiven(this.model, index, priority, weight, abstol, reltol, name, objcon, len, ind, val);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void setPWLObj(GRBVar var, double[] x, double[] y) throws GRBException {
        int error = 0;
        int col = var.getcolno();
        if (col < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        if (x == null || y == null) {
            throw new GRBException("Null arrays", 10002);
        }
        int points = x.length;
        if (y.length < points) {
            points = y.length;
        }
        if (points <= 0) {
            throw new GRBException("Empty arrays", 10003);
        }
        error = GurobiJni.setpwlobj(this.model, col, points, x, y);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void optimize() throws GRBException {
        String[] errormsg;
        int error;
        this.update();
        int hascb = 0;
        if (this.cb != null) {
            hascb = 1;
        }
        if ((error = this.jnioptimize(this.model, hascb, 0, null, errormsg = new String[1])) != 0) {
            throw new GRBException(errormsg[0], error);
        }
    }

    public void optimizeasync() throws GRBException {
        String[] errormsg;
        int error;
        this.update();
        int hascb = 0;
        long[] tcbdata = new long[1];
        if (this.cb != null) {
            hascb = 1;
        }
        if ((error = this.jnioptimize(this.model, hascb, 1, tcbdata, errormsg = new String[1])) != 0) {
            throw new GRBException(errormsg[0], error);
        }
        this.jcbdata = hascb != 0 ? tcbdata[0] : 0L;
    }

    public String optimizeBatch() throws GRBException {
        this.update();
        if (this.cb != null) {
            throw new GRBException("Batch Optimize does not support callbacks", 10003);
        }
        String[] value = new String[1];
        int error = this.jnioptimizebatch(this.model, value);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return value[0];
    }

    public void computeIIS() throws GRBException {
        String[] errormsg;
        int error;
        this.update();
        int hascb = 0;
        if (this.cb != null) {
            hascb = 1;
        }
        if ((error = this.jnicomputeIIS(this.model, hascb, errormsg = new String[1])) != 0) {
            throw new GRBException(errormsg[0], error);
        }
    }

    public void tune() throws GRBException {
        this.update();
        int error = GurobiJni.tunemodel(this.model);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void getTuneResult(int i) throws GRBException {
        int error = GurobiJni.gettuneresult(this.model, i);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void reset() throws GRBException {
        int error = GurobiJni.reset(this.model, 0);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void reset(int clearall) throws GRBException {
        int error = GurobiJni.reset(this.model, clearall);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void check() throws GRBException {
        int error = GurobiJni.checkmodel(this.model);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void terminate() {
        if (this.isfreed == 0) {
            GurobiJni.terminate(this.model);
        }
    }

    public void update() throws GRBException {
        GRBGenConstr genc;
        Object c;
        int error;
        int j;
        int i;
        if (this.model == 0L) {
            return;
        }
        int delcols = 0;
        int delvars = 0;
        for (i = 0; i < this.vars.size(); ++i) {
            GRBVar v = this.vars.get(i);
            j = v.getcolno();
            if (j <= -2) {
                ++delvars;
            }
            if (j >= -2) continue;
            ++delcols;
        }
        if (delvars > 0) {
            ArrayList<GRBVar> tmpvars = new ArrayList<GRBVar>();
            i = 1;
            if (delcols > 0) {
                i = delcols;
            }
            int[] cdelind = new int[i];
            delcols = 0;
            for (i = 0; i < this.vars.size(); ++i) {
                GRBVar v = this.vars.get(i);
                j = v.getcolno();
                if (j < -2) {
                    cdelind[delcols++] = -3 - j;
                }
                if (j < -1) continue;
                tmpvars.add(v);
            }
            if (delcols > 0 && (error = GurobiJni.delvars(this.model, delcols, cdelind)) != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error);
            }
            this.vars.clear();
            this.vars = tmpvars;
        }
        int delrows = 0;
        int delcons = 0;
        for (i = 0; i < this.constrs.size(); ++i) {
            GRBConstr c2 = this.constrs.get(i);
            j = c2.getrowno();
            if (j <= -2) {
                ++delcons;
            }
            if (j >= -2) continue;
            ++delrows;
        }
        if (delcons > 0) {
            ArrayList<GRBConstr> tmpconstrs = new ArrayList<GRBConstr>();
            i = 1;
            if (delrows > 0) {
                i = delrows;
            }
            int[] rdelind = new int[i];
            delrows = 0;
            for (i = 0; i < this.constrs.size(); ++i) {
                GRBConstr c3 = this.constrs.get(i);
                j = c3.getrowno();
                if (j < -2) {
                    rdelind[delrows++] = -3 - j;
                }
                if (j < -1) continue;
                tmpconstrs.add(c3);
            }
            if (delrows > 0 && (error = GurobiJni.delconstrs(this.model, delrows, rdelind)) != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error);
            }
            this.constrs.clear();
            this.constrs = tmpconstrs;
        }
        delrows = 0;
        int delsos = 0;
        for (i = 0; i < this.sos.size(); ++i) {
            GRBSOS c4 = this.sos.get(i);
            j = c4.getindex();
            if (j <= -2) {
                ++delsos;
            }
            if (j >= -2) continue;
            ++delrows;
        }
        if (delsos > 0) {
            ArrayList<GRBSOS> tmpsos = new ArrayList<GRBSOS>();
            i = 1;
            if (delrows > 0) {
                i = delrows;
            }
            int[] rdelind = new int[i];
            delrows = 0;
            for (i = 0; i < this.sos.size(); ++i) {
                c = this.sos.get(i);
                j = ((GRBSOS)c).getindex();
                if (j < -2) {
                    rdelind[delrows++] = -3 - j;
                }
                if (j < -1) continue;
                tmpsos.add((GRBSOS)c);
            }
            if (delrows > 0 && (error = GurobiJni.delsos(this.model, delrows, rdelind)) != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error);
            }
            this.sos.clear();
            this.sos = tmpsos;
        }
        delrows = 0;
        int delqconstrs = 0;
        for (i = 0; i < this.qconstrs.size(); ++i) {
            GRBQConstr qc = this.qconstrs.get(i);
            j = qc.getindex();
            if (j <= -2) {
                ++delqconstrs;
            }
            if (j >= -2) continue;
            ++delrows;
        }
        if (delqconstrs > 0) {
            ArrayList<GRBQConstr> tmpqconstrs = new ArrayList<GRBQConstr>();
            i = 1;
            if (delrows > 0) {
                i = delrows;
            }
            int[] rdelind = new int[i];
            delrows = 0;
            for (i = 0; i < this.qconstrs.size(); ++i) {
                GRBQConstr qc = this.qconstrs.get(i);
                j = qc.getindex();
                if (j < -2) {
                    rdelind[delrows++] = -3 - j;
                }
                if (j < -1) continue;
                tmpqconstrs.add(qc);
            }
            if (delrows > 0 && (error = GurobiJni.delqconstrs(this.model, delrows, rdelind)) != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error);
            }
            this.qconstrs.clear();
            this.qconstrs = tmpqconstrs;
        }
        delrows = 0;
        int delgenconstrs = 0;
        for (i = 0; i < this.genconstrs.size(); ++i) {
            genc = this.genconstrs.get(i);
            j = genc.getindex();
            if (j <= -2) {
                ++delgenconstrs;
            }
            if (j >= -2) continue;
            ++delrows;
        }
        if (delgenconstrs > 0) {
            ArrayList<GRBGenConstr> tmpgenconstrs = new ArrayList<GRBGenConstr>();
            i = 1;
            if (delrows > 0) {
                i = delrows;
            }
            int[] rdelind = new int[i];
            delrows = 0;
            for (i = 0; i < this.genconstrs.size(); ++i) {
                GRBGenConstr genc2 = this.genconstrs.get(i);
                j = genc2.getindex();
                if (j < -2) {
                    rdelind[delrows++] = -3 - j;
                }
                if (j < -1) continue;
                tmpgenconstrs.add(genc2);
            }
            if (delrows > 0 && (error = GurobiJni.delgenconstrs(this.model, delrows, rdelind)) != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error);
            }
            this.genconstrs.clear();
            this.genconstrs = tmpgenconstrs;
        }
        for (i = 0; i < this.newranges; ++i) {
            this.vars.add(new GRBVar(this.Cmodel, -1));
        }
        this.cols = this.vars.size();
        for (i = 0; i < this.cols; ++i) {
            GRBVar v = this.vars.get(i);
            v.setcolno(i);
        }
        this.rows = this.constrs.size();
        for (i = 0; i < this.rows; ++i) {
            c = this.constrs.get(i);
            ((GRBConstr)c).setrowno(i);
        }
        this.numsos = this.sos.size();
        for (i = 0; i < this.numsos; ++i) {
            GRBSOS s = this.sos.get(i);
            s.setindex(i);
        }
        this.numqconstrs = this.qconstrs.size();
        for (i = 0; i < this.numqconstrs; ++i) {
            GRBQConstr qc = this.qconstrs.get(i);
            qc.setindex(i);
        }
        this.numgenconstrs = this.genconstrs.size();
        for (i = 0; i < this.numgenconstrs; ++i) {
            genc = this.genconstrs.get(i);
            genc.setindex(i);
        }
        error = GurobiJni.updatemodel(this.model);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        this.newranges = 0;
        this.updatemode = -1;
        assert (this.cols == this.get(GRB.IntAttr.NumVars));
    }

    public GRBVar addVar(double lb, double ub, double obj, char type, String name) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int[] beg = new int[1];
        int[] ind = null;
        double[] val = null;
        double[] lbs = new double[1];
        double[] ubs = new double[1];
        double[] objs = new double[1];
        char[] types = new char[1];
        String[] names = new String[1];
        beg[0] = 0;
        lbs[0] = lb;
        ubs[0] = ub;
        objs[0] = obj;
        types[0] = type;
        names[0] = name;
        int error = GurobiJni.addvars(this.model, 1, 0, beg, ind, val, objs, lbs, ubs, types, names);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        int col = -1;
        if (this.getupdmode() == 1) {
            col = this.vars.size();
        }
        GRBVar var = new GRBVar(this.Cmodel, col);
        this.vars.add(var);
        return var;
    }

    public GRBVar addVar(double lb, double ub, double obj, char type, GRBConstr[] constrs, double[] coeffs, String name) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        if (constrs == null || constrs.length == 0) {
            return this.addVar(lb, ub, obj, type, name);
        }
        if (coeffs != null && coeffs.length < constrs.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        int len = constrs.length;
        int[] beg = new int[1];
        int[] ind = new int[len];
        double[] val = new double[len];
        double[] lbs = new double[1];
        double[] ubs = new double[1];
        double[] objs = new double[1];
        char[] types = new char[1];
        String[] names = new String[1];
        beg[0] = 0;
        lbs[0] = lb;
        ubs[0] = ub;
        objs[0] = obj;
        types[0] = type;
        names[0] = name;
        int l = 0;
        for (int i = 0; i < len; ++i) {
            int j = constrs[i].getrowno();
            if (j < 0) {
                throw new GRBException("Constraint isn't in the model", 20001);
            }
            double t = coeffs == null ? 1.0 : coeffs[i];
            if (!(Math.abs(t) > 1.0E-13)) continue;
            val[l] = t;
            ind[l] = j;
            ++l;
        }
        int error = GurobiJni.addvars(this.model, 1, l, beg, ind, val, objs, lbs, ubs, types, names);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        int col = -1;
        if (this.getupdmode() == 1) {
            col = this.vars.size();
        }
        GRBVar var = new GRBVar(this.Cmodel, col);
        this.vars.add(var);
        return var;
    }

    public GRBVar addVar(double lb, double ub, double obj, char type, GRBColumn col, String name) throws GRBException {
        if (col == null) {
            return this.addVar(lb, ub, obj, type, name);
        }
        int len = col.size();
        GRBConstr[] xconstrs = new GRBConstr[len];
        double[] xcoeffs = new double[len];
        for (int i = 0; i < len; ++i) {
            xconstrs[i] = col.getConstr(i);
            xcoeffs[i] = col.getCoeff(i);
        }
        return this.addVar(lb, ub, obj, type, xconstrs, xcoeffs, name);
    }

    public GRBVar[] addVars(int count, char type) throws GRBException {
        if (count <= 0) {
            return null;
        }
        char[] vtype = new char[count];
        for (int i = 0; i < count; ++i) {
            vtype[i] = type;
        }
        return this.addVars(null, null, null, vtype, null, null);
    }

    public GRBVar[] addVars(double[] lb, double[] ub, double[] obj, char[] type, String[] names) throws GRBException {
        return this.addVars(lb, ub, obj, type, names, null);
    }

    public GRBVar[] addVars(double[] lb, double[] ub, double[] obj, char[] type, String[] names, int start, int len) throws GRBException {
        int i;
        int k;
        if (len <= 0) {
            return null;
        }
        int last = start + len;
        if (start < 0 || names != null && names.length < last || lb != null && lb.length < last || ub != null && ub.length < last || obj != null && obj.length < last || type != null && type.length < last) {
            throw new GRBException("Invalid arguments", 10003);
        }
        String[] xname = null;
        double[] xlb = new double[len];
        double[] xub = new double[len];
        double[] xobj = new double[len];
        char[] xtype = new char[len];
        if (names != null) {
            xname = new String[len];
            k = 0;
            for (i = start; i < last; ++i) {
                xname[k++] = names[i];
            }
        }
        k = 0;
        for (i = start; i < last; ++i) {
            xtype[k] = type == null ? 67 : type[i];
            xlb[k] = lb == null ? 0.0 : lb[i];
            xub[k] = ub == null ? (xtype[k] == 'B' ? 1.0 : 1.0E100) : ub[i];
            xobj[k] = obj == null ? 0.0 : obj[i];
            ++k;
        }
        return this.addVars(xlb, xub, xobj, xtype, xname, null);
    }

    public GRBVar[] addVars(double[] lb, double[] ub, double[] obj, char[] type, String[] names, GRBColumn[] cols) throws GRBException {
        int i;
        double[] val;
        int[] ind;
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        if (obj == null && lb == null && ub == null && obj == null && type == null && cols == null) {
            throw new GRBException("Invalid arguments", 10003);
        }
        int num = Integer.MAX_VALUE;
        if (lb != null && lb.length < num) {
            num = lb.length;
        }
        if (ub != null && ub.length < num) {
            num = ub.length;
        }
        if (obj != null && obj.length < num) {
            num = obj.length;
        }
        if (type != null && type.length < num) {
            num = type.length;
        }
        if (cols != null && cols.length < num) {
            num = cols.length;
        }
        if (num == 0) {
            return null;
        }
        int nz = 0;
        int[] beg = new int[num];
        if (cols == null) {
            for (int i2 = 0; i2 < num; ++i2) {
                beg[i2] = 0;
            }
            ind = null;
            val = null;
        } else {
            int j;
            GRBConstr c;
            int len;
            int ii;
            for (ii = 0; ii < num; ++ii) {
                len = cols[ii].size();
                nz += len;
                for (i = 0; i < len; ++i) {
                    c = cols[ii].getConstr(i);
                    j = c.getrowno();
                    if (j >= 0) continue;
                    throw new GRBException("Constraint isn't in the model", 20001);
                }
            }
            ind = new int[nz];
            val = new double[nz];
            nz = 0;
            for (ii = 0; ii < num; ++ii) {
                beg[ii] = nz;
                len = cols[ii].size();
                for (i = 0; i < len; ++i) {
                    c = cols[ii].getConstr(i);
                    j = c.getrowno();
                    double coe = cols[ii].getCoeff(i);
                    if (!(Math.abs(coe) > 1.0E-13)) continue;
                    val[nz] = coe;
                    ind[nz] = j;
                    ++nz;
                }
            }
        }
        int error = GurobiJni.addvars(this.model, num, nz, beg, ind, val, obj, lb, ub, type, names);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBVar[] newvars = new GRBVar[num];
        if (this.getupdmode() == 1) {
            int thiscol = this.vars.size();
            for (int i3 = 0; i3 < num; ++i3) {
                newvars[i3] = new GRBVar(this.Cmodel, thiscol);
                ++thiscol;
                this.vars.add(newvars[i3]);
            }
        } else {
            for (i = 0; i < num; ++i) {
                newvars[i] = new GRBVar(this.Cmodel, -1);
                this.vars.add(newvars[i]);
            }
        }
        return newvars;
    }

    public GRBConstr addConstr(GRBLinExpr lhsExpr, char sense, GRBLinExpr rhsExpr, String name) throws GRBException {
        GRBLinExpr ex = new GRBLinExpr(lhsExpr);
        ex.multAdd(-1.0, rhsExpr);
        return this.addConstr(ex, sense, -1.0E100, 0.0, name);
    }

    public GRBConstr addConstr(GRBLinExpr lhsExpr, char sense, GRBVar rhsVar, String name) throws GRBException {
        GRBLinExpr ex = new GRBLinExpr(lhsExpr);
        ex.addTerm(-1.0, rhsVar);
        return this.addConstr(ex, sense, -1.0E100, 0.0, name);
    }

    public GRBConstr addConstr(GRBVar lhsVar, char sense, GRBLinExpr rhsExpr, String name) throws GRBException {
        GRBLinExpr ex = new GRBLinExpr();
        ex.addTerm(1.0, lhsVar);
        ex.multAdd(-1.0, rhsExpr);
        return this.addConstr(ex, sense, -1.0E100, 0.0, name);
    }

    public GRBConstr addConstr(GRBVar lhsVar, char sense, GRBVar rhsVar, String name) throws GRBException {
        GRBLinExpr ex = new GRBLinExpr();
        ex.addTerm(1.0, lhsVar);
        ex.addTerm(-1.0, rhsVar);
        return this.addConstr(ex, sense, -1.0E100, 0.0, name);
    }

    public GRBConstr addConstr(GRBVar lhsVar, char sense, double rhs, String name) throws GRBException {
        GRBLinExpr ex = new GRBLinExpr();
        ex.addTerm(1.0, lhsVar);
        return this.addConstr(ex, sense, -1.0E100, rhs, name);
    }

    public GRBConstr addConstr(double lhs, char sense, GRBVar rhsVar, String name) throws GRBException {
        GRBLinExpr ex = new GRBLinExpr();
        ex.addTerm(-1.0, rhsVar);
        return this.addConstr(ex, sense, -1.0E100, -lhs, name);
    }

    public GRBConstr addConstr(GRBLinExpr lhsExpr, char sense, double rhs, String name) throws GRBException {
        return this.addConstr(lhsExpr, sense, -1.0E100, rhs, name);
    }

    public GRBConstr addConstr(double lhs, char sense, GRBLinExpr rhsExpr, String name) throws GRBException {
        GRBLinExpr ex = new GRBLinExpr();
        ex.multAdd(-1.0, rhsExpr);
        return this.addConstr(ex, sense, -1.0E100, -lhs, name);
    }

    private GRBConstr addConstr(GRBLinExpr expr, char sense, double lhs, double rhs, String name) throws GRBException {
        int k;
        GRBVar v;
        int i;
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        boolean upd = false;
        int nz = expr.size();
        int[] beg = new int[1];
        int[] ind = new int[nz];
        double[] val = new double[nz];
        char[] senses = new char[1];
        double[] rhses = new double[1];
        double[] lhses = new double[1];
        String[] names = new String[1];
        for (i = 0; i < nz; ++i) {
            v = expr.getVar(i);
            k = v.getcolno();
            if (k >= 0) continue;
            throw new GRBException("Not in the model", 20001);
        }
        nz = 0;
        for (i = 0; i < expr.size(); ++i) {
            v = expr.getVar(i);
            k = v.getcolno();
            if (k < 0) {
                throw new GRBException("Internal Error20003");
            }
            ind[nz] = k;
            val[nz] = expr.getCoeff(i);
            ++nz;
        }
        int[] tmp = new int[]{nz};
        int error = GurobiJni.clean2(tmp, ind, val);
        if (error != 0) {
            throw new GRBException("Out of memory", error);
        }
        nz = tmp[0];
        beg[0] = 0;
        senses[0] = sense;
        rhses[0] = rhs - expr.getConstant();
        lhses[0] = lhs;
        if (lhs > -1.0E100) {
            lhses[0] = lhses[0] - expr.getConstant();
        } else {
            lhses = null;
        }
        names[0] = name;
        error = GurobiJni.addconstrs(this.model, 1, nz, beg, ind, val, senses, lhses, rhses, names);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        int row = -1;
        if (this.getupdmode() == 1) {
            row = this.constrs.size();
        }
        GRBConstr c = new GRBConstr(this.Cmodel, row);
        this.constrs.add(c);
        return c;
    }

    public GRBConstr addRange(GRBLinExpr expr, double lower, double upper, String name) throws GRBException {
        if (lower <= -1.0E25 == upper >= 1.0E25) {
            ++this.newranges;
        }
        double xlower = lower;
        double xupper = upper;
        if (xlower < -1.0E25) {
            xlower = -1.0E25;
        }
        if (xupper > 1.0E25) {
            xupper = 1.0E25;
        }
        return this.addConstr(expr, '<', xlower, xupper, name);
    }

    public GRBConstr[] addConstrs(int count) throws GRBException {
        if (count <= 0) {
            return null;
        }
        double[] rhs = new double[count];
        for (int i = 0; i < count; ++i) {
            rhs[i] = 0.0;
        }
        return this.addConstrs(null, null, rhs, null);
    }

    public GRBConstr[] addConstrs(GRBLinExpr[] lhsExprs, char[] senses, double[] rhss, String[] names) throws GRBException {
        return this.addConstrs(lhsExprs, senses, null, rhss, names);
    }

    private GRBConstr[] addConstrs(GRBLinExpr[] exprs, char[] senses, double[] lhss, double[] rhss, String[] names) throws GRBException {
        int error;
        int i;
        char[] xsense;
        if (exprs == null && senses == null && rhss == null && names == null) {
            throw new GRBException("Invalid arguments", 10003);
        }
        if (lhss != null && rhss == null) {
            throw new GRBException("Invalid arguments", 10003);
        }
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int num = Integer.MAX_VALUE;
        if (exprs != null && exprs.length < num) {
            num = exprs.length;
        }
        if (senses != null && senses.length < num) {
            num = senses.length;
        }
        if (rhss != null && rhss.length < num) {
            num = rhss.length;
        }
        if (lhss != null && lhss.length < num) {
            num = lhss.length;
        }
        if (names != null && names.length < num) {
            num = names.length;
        }
        boolean upd = false;
        int m = 0;
        int nz = 0;
        int[] beg = new int[num];
        int[] ind = null;
        double[] val = null;
        double[] xlhs = null;
        String[] xnames = null;
        if (senses != null) {
            xsense = senses;
        } else {
            xsense = new char[num];
            for (i = 0; i < num; ++i) {
                xsense[i] = 60;
            }
        }
        double[] xrhs = new double[num];
        if (rhss != null) {
            for (i = 0; i < num; ++i) {
                xrhs[i] = rhss[i];
            }
        } else {
            for (i = 0; i < num; ++i) {
                xrhs[i] = 0.0;
            }
        }
        if (names != null) {
            xnames = names;
        }
        if (exprs != null) {
            int k;
            int l;
            int j;
            for (j = 0; j < num; ++j) {
                l = exprs[j].size();
                if (l > m) {
                    m = l;
                }
                nz += l;
                for (i = 0; i < l; ++i) {
                    GRBVar v = exprs[j].getVar(i);
                    k = v.getcolno();
                    if (k >= 0) continue;
                    throw new GRBException("Not in the model", 20001);
                }
            }
            ind = new int[nz];
            val = new double[nz];
            int[] tind = new int[m];
            double[] tval = new double[m];
            nz = 0;
            for (j = 0; j < num; ++j) {
                int n = j;
                xrhs[n] = xrhs[n] - exprs[j].getConstant();
                beg[j] = nz;
                l = 0;
                for (i = 0; i < exprs[j].size(); ++i) {
                    GRBVar v = exprs[j].getVar(i);
                    k = v.getcolno();
                    if (k < 0) {
                        throw new GRBException("Internal Error20003");
                    }
                    tind[l] = k;
                    tval[l] = exprs[j].getCoeff(i);
                    ++l;
                }
                if (l == 0) continue;
                int[] tmp = new int[]{l};
                error = GurobiJni.clean2(tmp, tind, tval);
                if (error != 0) {
                    throw new GRBException("Out of memory", error);
                }
                l = tmp[0];
                for (i = 0; i < l; ++i) {
                    ind[nz] = tind[i];
                    val[nz] = tval[i];
                    ++nz;
                }
            }
        }
        if (lhss != null) {
            xlhs = new double[num];
            for (i = 0; i < num; ++i) {
                xlhs[i] = lhss[i] + xrhs[i] - rhss[i];
            }
        }
        if ((error = GurobiJni.addconstrs(this.model, num, nz, beg, ind, val, xsense, xlhs, xrhs, xnames)) != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBConstr[] newconstrs = new GRBConstr[num];
        if (this.getupdmode() == 1) {
            int row = this.constrs.size();
            for (i = 0; i < num; ++i) {
                newconstrs[i] = new GRBConstr(this.Cmodel, row);
                ++row;
                this.constrs.add(newconstrs[i]);
            }
        } else {
            for (i = 0; i < num; ++i) {
                newconstrs[i] = new GRBConstr(this.Cmodel, -1);
                this.constrs.add(newconstrs[i]);
            }
        }
        return newconstrs;
    }

    public GRBConstr[] addConstrs(GRBLinExpr[] lhsExprs, char[] senses, double[] rhss, String[] names, int start, int len) throws GRBException {
        int last = start + len;
        if (start < 0 || lhsExprs != null && lhsExprs.length < last || names != null && names.length < last || senses != null && senses.length < last || rhss != null && rhss.length < last) {
            throw new GRBException("Invalid arguments", 10003);
        }
        if (lhsExprs == null && senses == null && rhss == null && names == null) {
            throw new GRBException("Invalid arguments", 10003);
        }
        if (len <= 0) {
            return null;
        }
        if (start == 0 && (lhsExprs != null && lhsExprs.length == len || names != null && names.length == len || senses != null && senses.length == len || rhss != null && rhss.length == len)) {
            return this.addConstrs(lhsExprs, senses, rhss, names);
        }
        String[] xnames = null;
        GRBLinExpr[] xexpr = null;
        char[] xsense = null;
        double[] xrhs = null;
        if (names != null) {
            xnames = new String[len];
        }
        if (lhsExprs != null) {
            xexpr = new GRBLinExpr[len];
        }
        if (senses != null) {
            xsense = new char[len];
        }
        if (rhss != null) {
            xrhs = new double[len];
        }
        int k = 0;
        for (int i = start; i < last; ++i) {
            if (lhsExprs != null) {
                xexpr[k] = lhsExprs[i];
            }
            if (senses != null) {
                xsense[k] = senses[i];
            }
            if (rhss != null) {
                xrhs[k] = rhss[i];
            }
            if (names != null) {
                xnames[k] = names[i];
            }
            ++k;
        }
        return this.addConstrs(xexpr, xsense, null, xrhs, xnames);
    }

    public GRBConstr[] addRanges(GRBLinExpr[] exprs, double[] lower, double[] upper, String[] names) throws GRBException {
        int num = Integer.MAX_VALUE;
        if (exprs != null && exprs.length < num) {
            num = exprs.length;
        }
        if (lower != null && lower.length < num) {
            num = lower.length;
        }
        if (upper != null && upper.length < num) {
            num = upper.length;
        }
        if (names != null && names.length < num) {
            num = names.length;
        }
        double[] xlower = new double[num];
        double[] xupper = new double[num];
        for (int i = 0; i < num; ++i) {
            xlower[i] = lower == null || lower[i] < -1.0E25 ? -1.0E25 : lower[i];
            xupper[i] = upper == null || upper[i] > 1.0E25 ? 1.0E25 : upper[i];
            if (xlower[i] <= -1.0E25 != xupper[i] >= 1.0E25) continue;
            ++this.newranges;
        }
        return this.addConstrs(exprs, null, xlower, xupper, names);
    }

    public GRBQConstr addQConstr(GRBQuadExpr lhsExpr, char sense, GRBQuadExpr rhsExpr, String name) throws GRBException {
        GRBQuadExpr ex = new GRBQuadExpr(lhsExpr);
        ex.multAdd(-1.0, rhsExpr);
        return this.addQConstr(ex, sense, name);
    }

    public GRBQConstr addQConstr(GRBQuadExpr lhsExpr, char sense, GRBLinExpr rhsExpr, String name) throws GRBException {
        GRBQuadExpr ex = new GRBQuadExpr(lhsExpr);
        ex.multAdd(-1.0, rhsExpr);
        return this.addQConstr(ex, sense, name);
    }

    public GRBQConstr addQConstr(GRBLinExpr lhsExpr, char sense, GRBQuadExpr rhsExpr, String name) throws GRBException {
        GRBQuadExpr ex = new GRBQuadExpr(lhsExpr);
        ex.multAdd(-1.0, rhsExpr);
        return this.addQConstr(ex, sense, name);
    }

    public GRBQConstr addQConstr(GRBQuadExpr lhsExpr, char sense, GRBVar rhsVar, String name) throws GRBException {
        GRBQuadExpr ex = new GRBQuadExpr(lhsExpr);
        ex.addTerm(-1.0, rhsVar);
        return this.addQConstr(ex, sense, name);
    }

    public GRBQConstr addQConstr(GRBVar lhsVar, char sense, GRBQuadExpr rhsExpr, String name) throws GRBException {
        GRBQuadExpr ex = new GRBQuadExpr();
        ex.addTerm(1.0, lhsVar);
        ex.multAdd(-1.0, rhsExpr);
        return this.addQConstr(ex, sense, name);
    }

    public GRBQConstr addQConstr(GRBQuadExpr lhsExpr, char sense, double rhs, String name) throws GRBException {
        GRBQuadExpr ex = new GRBQuadExpr(lhsExpr);
        ex.addConstant(-rhs);
        return this.addQConstr(ex, sense, name);
    }

    public GRBQConstr addQConstr(double lhs, char sense, GRBQuadExpr rhsExpr, String name) throws GRBException {
        GRBQuadExpr ex = new GRBQuadExpr();
        ex.addConstant(lhs);
        ex.multAdd(-1.0, rhsExpr);
        return this.addQConstr(ex, sense, name);
    }

    private GRBQConstr addQConstr(GRBQuadExpr lhsExpr, char sense, String name) throws GRBException {
        int i;
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        GRBLinExpr linexpr = lhsExpr.getLinExpr();
        int lnz = linexpr.size();
        int[] lind = new int[lnz];
        double[] lval = new double[lnz];
        int qnz = lhsExpr.size();
        int[] qrow = new int[qnz];
        int[] qcol = new int[qnz];
        double[] qval = new double[qnz];
        char[] senses = new char[1];
        double[] rhses = new double[1];
        double[] lhses = new double[1];
        String[] names = new String[1];
        for (i = 0; i < lnz; ++i) {
            GRBVar v = linexpr.getVar(i);
            if (v.getcolno() < 0) {
                throw new GRBException("Not in the model", 20001);
            }
            lind[i] = v.getcolno();
            lval[i] = linexpr.getCoeff(i);
        }
        int[] tmp = new int[]{lnz};
        int error = GurobiJni.clean2(tmp, lind, lval);
        if (error != 0) {
            throw new GRBException("Out of memory", error);
        }
        lnz = tmp[0];
        for (i = 0; i < qnz; ++i) {
            GRBVar v1 = lhsExpr.getVar1(i);
            GRBVar v2 = lhsExpr.getVar2(i);
            if (v1.getcolno() < 0 || v2.getcolno() < 0) {
                throw new GRBException("Not in the model", 20001);
            }
            if (v1.getcolno() < v2.getcolno()) {
                qrow[i] = v1.getcolno();
                qcol[i] = v2.getcolno();
            } else {
                qcol[i] = v1.getcolno();
                qrow[i] = v2.getcolno();
            }
            qval[i] = lhsExpr.getCoeff(i);
        }
        tmp[0] = qnz;
        error = GurobiJni.clean3(tmp, qrow, qcol, qval);
        if (error != 0) {
            throw new GRBException("Out of memory", error);
        }
        qnz = tmp[0];
        error = GurobiJni.addqconstr(this.model, lnz, lind, lval, qnz, qrow, qcol, qval, sense, -linexpr.getConstant(), name);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBQConstr qc = new GRBQConstr(this.Cmodel, -1);
        this.qconstrs.add(qc);
        return qc;
    }

    public GRBGenConstr addGenConstrMax(GRBVar resvar, GRBVar[] vars, double constant, String name) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int resind = resvar.getcolno();
        if (resind < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        if (vars == null) {
            throw new GRBException("Invalid arguments", 10003);
        }
        int len = vars.length;
        int[] ind = new int[len];
        for (int i = 0; i < len; ++i) {
            int j = vars[i].getcolno();
            if (j < 0) {
                throw new GRBException("Variable not in the model", 20001);
            }
            ind[i] = j;
        }
        int error = GurobiJni.addgenconstrmax(this.model, name, resind, len, ind, constant);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public GRBGenConstr addGenConstrMin(GRBVar resvar, GRBVar[] vars, double constant, String name) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int resind = resvar.getcolno();
        if (resind < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        if (vars == null) {
            throw new GRBException("Invalid arguments", 10003);
        }
        int len = vars.length;
        int[] ind = new int[len];
        for (int i = 0; i < len; ++i) {
            int j = vars[i].getcolno();
            if (j < 0) {
                throw new GRBException("Variable not in the model", 20001);
            }
            ind[i] = j;
        }
        int error = GurobiJni.addgenconstrmin(this.model, name, resind, len, ind, constant);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public GRBGenConstr addGenConstrAbs(GRBVar resvar, GRBVar argvar, String name) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int resind = resvar.getcolno();
        if (resind < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int argind = argvar.getcolno();
        if (argind < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int error = GurobiJni.addgenconstrabs(this.model, name, resind, argind);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public GRBGenConstr addGenConstrAnd(GRBVar resvar, GRBVar[] vars, String name) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int resind = resvar.getcolno();
        if (resind < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        if (vars == null) {
            throw new GRBException("Invalid arguments", 10003);
        }
        int len = vars.length;
        int[] ind = new int[len];
        for (int i = 0; i < len; ++i) {
            int j = vars[i].getcolno();
            if (j < 0) {
                throw new GRBException("Variable not in the model", 20001);
            }
            ind[i] = j;
        }
        int error = GurobiJni.addgenconstrand(this.model, name, resind, len, ind);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public GRBGenConstr addGenConstrOr(GRBVar resvar, GRBVar[] vars, String name) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int resind = resvar.getcolno();
        if (resind < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        if (vars == null) {
            throw new GRBException("Invalid arguments", 10003);
        }
        int len = vars.length;
        int[] ind = new int[len];
        for (int i = 0; i < len; ++i) {
            int j = vars[i].getcolno();
            if (j < 0) {
                throw new GRBException("Variable not in the model", 20001);
            }
            ind[i] = j;
        }
        int error = GurobiJni.addgenconstror(this.model, name, resind, len, ind);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public GRBGenConstr addGenConstrNorm(GRBVar resvar, GRBVar[] vars, double which, String name) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int resind = resvar.getcolno();
        if (resind < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        if (vars == null) {
            throw new GRBException("Invalid arguments", 10003);
        }
        int len = vars.length;
        int[] ind = new int[len];
        for (int i = 0; i < len; ++i) {
            int j = vars[i].getcolno();
            if (j < 0) {
                throw new GRBException("Variable not in the model", 20001);
            }
            ind[i] = j;
        }
        int error = GurobiJni.addgenconstrnorm(this.model, name, resind, len, ind, which);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public GRBGenConstr addGenConstrIndicator(GRBVar binvar, int binval, GRBLinExpr expr, char sense, double rhs, String name) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int binind = binvar.getcolno();
        if (binind < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int len = expr.size();
        int[] ind = new int[len];
        double[] val = new double[len];
        for (int i = 0; i < len; ++i) {
            GRBVar v = expr.getVar(i);
            int j = v.getcolno();
            if (j < 0) {
                throw new GRBException("Variable not in the model", 20001);
            }
            ind[i] = j;
            val[i] = expr.getCoeff(i);
        }
        int[] tmp = new int[]{len};
        int error = GurobiJni.clean2(tmp, ind, val);
        if (error != 0) {
            throw new GRBException("Out of memory", error);
        }
        len = tmp[0];
        error = GurobiJni.addgenconstrindicator(this.model, name, binind, binval, len, ind, val, sense, rhs -= expr.getConstant());
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public GRBGenConstr addGenConstrPWL(GRBVar xvar, GRBVar yvar, double[] xpts, double[] ypts, String name) throws GRBException {
        int error;
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int xind = xvar.getcolno();
        int yind = yvar.getcolno();
        if (xind < 0 || yind < 0) {
            throw new GRBException("xvar or yvar not in the model", 20001);
        }
        if (xpts == null || xpts.length < 2 || ypts == null || ypts.length < 2) {
            throw new GRBException("Invalid arguments", 10003);
        }
        int npts = xpts.length;
        if (ypts.length < npts) {
            npts = ypts.length;
        }
        if ((error = GurobiJni.addgenconstrpwl(this.model, name, xind, yind, npts, xpts, ypts)) != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public GRBGenConstr addGenConstrPoly(GRBVar xvar, GRBVar yvar, double[] p, String name, String options) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int xind = xvar.getcolno();
        int yind = yvar.getcolno();
        if (xind < 0 || yind < 0) {
            throw new GRBException("xvar or yvar not in the model", 20001);
        }
        if (p == null || p.length <= 0) {
            throw new GRBException("Empty polynomial function constraint", 10003);
        }
        int plen = p.length;
        int error = GurobiJni.addgenconstrpoly(this.model, name, xind, yind, plen, p, options);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public GRBGenConstr addGenConstrExp(GRBVar xvar, GRBVar yvar, String name, String options) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int xind = xvar.getcolno();
        int yind = yvar.getcolno();
        if (xind < 0 || yind < 0) {
            throw new GRBException("xvar or yvar not in the model", 20001);
        }
        int error = GurobiJni.addgenconstrexp(this.model, name, xind, yind, options);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public GRBGenConstr addGenConstrExpA(GRBVar xvar, GRBVar yvar, double a, String name, String options) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int xind = xvar.getcolno();
        int yind = yvar.getcolno();
        if (xind < 0 || yind < 0) {
            throw new GRBException("xvar or yvar not in the model", 20001);
        }
        int error = GurobiJni.addgenconstrexpa(this.model, name, xind, yind, a, options);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public GRBGenConstr addGenConstrLog(GRBVar xvar, GRBVar yvar, String name, String options) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int xind = xvar.getcolno();
        int yind = yvar.getcolno();
        if (xind < 0 || yind < 0) {
            throw new GRBException("xvar or yvar not in the model", 20001);
        }
        int error = GurobiJni.addgenconstrlog(this.model, name, xind, yind, options);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public GRBGenConstr addGenConstrLogA(GRBVar xvar, GRBVar yvar, double a, String name, String options) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int xind = xvar.getcolno();
        int yind = yvar.getcolno();
        if (xind < 0 || yind < 0) {
            throw new GRBException("xvar or yvar not in the model", 20001);
        }
        int error = GurobiJni.addgenconstrloga(this.model, name, xind, yind, a, options);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public GRBGenConstr addGenConstrPow(GRBVar xvar, GRBVar yvar, double a, String name, String options) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int xind = xvar.getcolno();
        int yind = yvar.getcolno();
        if (xind < 0 || yind < 0) {
            throw new GRBException("xvar or yvar not in the model", 20001);
        }
        int error = GurobiJni.addgenconstrpow(this.model, name, xind, yind, a, options);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public GRBGenConstr addGenConstrSin(GRBVar xvar, GRBVar yvar, String name, String options) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int xind = xvar.getcolno();
        int yind = yvar.getcolno();
        if (xind < 0 || yind < 0) {
            throw new GRBException("xvar or yvar not in the model", 20001);
        }
        int error = GurobiJni.addgenconstrsin(this.model, name, xind, yind, options);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public GRBGenConstr addGenConstrCos(GRBVar xvar, GRBVar yvar, String name, String options) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int xind = xvar.getcolno();
        int yind = yvar.getcolno();
        if (xind < 0 || yind < 0) {
            throw new GRBException("xvar or yvar not in the model", 20001);
        }
        int error = GurobiJni.addgenconstrcos(this.model, name, xind, yind, options);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public GRBGenConstr addGenConstrTan(GRBVar xvar, GRBVar yvar, String name, String options) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int xind = xvar.getcolno();
        int yind = yvar.getcolno();
        if (xind < 0 || yind < 0) {
            throw new GRBException("xvar or yvar not in the model", 20001);
        }
        int error = GurobiJni.addgenconstrtan(this.model, name, xind, yind, options);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public GRBGenConstr addGenConstrLogistic(GRBVar xvar, GRBVar yvar, String name, String options) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int xind = xvar.getcolno();
        int yind = yvar.getcolno();
        if (xind < 0 || yind < 0) {
            throw new GRBException("xvar or yvar not in the model", 20001);
        }
        int error = GurobiJni.addgenconstrlogistic(this.model, name, xind, yind, options);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBGenConstr genc = new GRBGenConstr(this.Cmodel, -1);
        this.genconstrs.add(genc);
        return genc;
    }

    public void remove(GRBVar var) throws GRBException {
        int j = var.getcolno();
        if (j >= 0) {
            j = -3 - j;
        } else if (j == -1) {
            throw new GRBException("Not in the model for removing", 20001);
        }
        var.setcolno(j);
    }

    public void remove(GRBConstr constr) throws GRBException {
        int i = constr.getrowno();
        if (i >= 0) {
            i = -3 - i;
        } else if (i == -1) {
            throw new GRBException("Not in the model for removing", 20001);
        }
        constr.setrowno(i);
    }

    public void chgCoeff(GRBConstr constr, GRBVar var, double newval) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        if (constr == null || constr.getrowno() < 0 || var == null || var.getcolno() < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] cind = new int[1];
        int[] vind = new int[1];
        double[] val = new double[1];
        cind[0] = constr.getrowno();
        vind[0] = var.getcolno();
        val[0] = newval;
        int error = GurobiJni.chgcoeffs(this.model, 1, cind, vind, val);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void chgCoeffs(GRBConstr[] constrs, GRBVar[] vars, double[] newvals) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        if (vars == null || constrs == null || newvals == null) {
            return;
        }
        int nz = vars.length;
        if (nz > constrs.length) {
            nz = constrs.length;
        }
        if (nz > newvals.length) {
            nz = newvals.length;
        }
        if (nz <= 0) {
            return;
        }
        int[] cind = new int[nz];
        int[] vind = new int[nz];
        int l = 0;
        for (int k = 0; k < nz; ++k) {
            int i = constrs[k].getrowno();
            int j = vars[k].getcolno();
            if (i < 0 || j < 0) {
                throw new GRBException("Not in the model", 20001);
            }
            cind[l] = i;
            vind[l] = j;
            ++l;
        }
        int error = GurobiJni.chgcoeffs(this.model, nz, cind, vind, newvals);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public double getCoeff(GRBConstr constr, GRBVar var) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int i = constr.getrowno();
        int j = var.getcolno();
        if (i < 0 || i >= this.rows || j < 0 || j >= this.cols) {
            throw new GRBException("Not in the model", 20001);
        }
        double[] val = new double[1];
        int error = GurobiJni.getcoeff(this.model, i, j, val);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return val[0];
    }

    public GRBColumn getCol(GRBVar var) throws GRBException {
        int error = 0;
        int col = var.getcolno();
        if (col < 0 || col >= this.cols) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] nz = new int[]{0};
        error = GurobiJni.getvars(this.model, nz, null, null, null, col, 1);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        int[] beg = new int[2];
        int[] nonz = new int[1];
        int[] ind = new int[nz[0]];
        double[] val = new double[nz[0]];
        error = GurobiJni.getvars(this.model, nz, beg, ind, val, col, 1);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBColumn co = new GRBColumn();
        for (int i = 0; i < nz[0]; ++i) {
            int j = ind[i];
            co.addTerm(val[i], this.constrs.get(j));
        }
        return co;
    }

    public GRBLinExpr getRow(GRBConstr constr) throws GRBException {
        int error = 0;
        int row = constr.getrowno();
        if (row < 0 || row >= this.rows) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] nz = new int[]{0};
        error = GurobiJni.getconstrs(this.model, nz, null, null, null, row, 1);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        int[] beg = new int[2];
        int[] nonz = new int[1];
        int[] ind = new int[nz[0]];
        double[] val = new double[nz[0]];
        error = GurobiJni.getconstrs(this.model, nz, beg, ind, val, row, 1);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBLinExpr le = new GRBLinExpr();
        for (int i = 0; i < nz[0]; ++i) {
            int j = ind[i];
            le.addTerm(val[i], this.vars.get(j));
        }
        return le;
    }

    public GRBSOS addSOS(GRBVar[] vars, double[] weights, int type) throws GRBException {
        if (weights == null || vars == null || vars.length < 2) {
            return null;
        }
        int num = vars.length;
        if (weights.length < vars.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        int[] beg = new int[2];
        int[] types = new int[1];
        int[] ind = new int[num];
        int l = 0;
        for (int i = 0; i < num; ++i) {
            int j = vars[i].getcolno();
            if (j < 0) {
                throw new GRBException("Variable not in the model", 20001);
            }
            ind[l++] = j;
        }
        beg[0] = 0;
        types[0] = type;
        int error = GurobiJni.addsos(this.model, 1, num, types, beg, ind, weights);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBSOS s = new GRBSOS(this.Cmodel, -1);
        this.sos.add(s);
        return s;
    }

    public int getSOS(GRBSOS sos, GRBVar[] vars, double[] weights, int[] type) throws GRBException {
        int sosi = sos.getindex();
        if (sosi < 0) {
            return 0;
        }
        int error = 0;
        int[] num = new int[]{0};
        error = GurobiJni.getsos(this.model, num, null, null, null, null, sosi, 1);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (vars == null) {
            return num[0];
        }
        if (vars.length < num[0] || weights.length < num[0]) {
            throw new GRBException("Array too short", 10003);
        }
        int[] beg = new int[2];
        int[] ind = new int[num[0]];
        error = GurobiJni.getsos(this.model, num, type, beg, ind, weights, sosi, 1);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        for (int i = 0; i < num[0]; ++i) {
            GRBVar v;
            vars[i] = v = this.vars.get(ind[i]);
        }
        return num[0];
    }

    public void getGenConstrMax(GRBGenConstr genc, GRBVar[] resvar, GRBVar[] vars, int[] len, double[] constant) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] resind = new int[1];
        int[] nvars = new int[1];
        int error = GurobiJni.getgenconstrmax(this.model, genci, resind, nvars, null, constant);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (resvar != null) {
            resvar[0] = this.vars.get(resind[0]);
        }
        if (vars != null) {
            if (vars.length < nvars[0]) {
                throw new GRBException("Array too short", 10003);
            }
            int[] ind = new int[nvars[0]];
            error = GurobiJni.getgenconstrmax(this.model, genci, null, null, ind, null);
            if (error != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error);
            }
            for (int i = 0; i < nvars[0]; ++i) {
                vars[i] = this.vars.get(ind[i]);
            }
        }
        if (len != null) {
            len[0] = nvars[0];
        }
    }

    public void getGenConstrMin(GRBGenConstr genc, GRBVar[] resvar, GRBVar[] vars, int[] len, double[] constant) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] resind = new int[1];
        int[] nvars = new int[1];
        int error = GurobiJni.getgenconstrmin(this.model, genci, resind, nvars, null, constant);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (resvar != null) {
            resvar[0] = this.vars.get(resind[0]);
        }
        if (vars != null) {
            if (vars.length < nvars[0]) {
                throw new GRBException("Array too short", 10003);
            }
            int[] ind = new int[nvars[0]];
            error = GurobiJni.getgenconstrmin(this.model, genci, null, null, ind, null);
            if (error != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error);
            }
            for (int i = 0; i < nvars[0]; ++i) {
                vars[i] = this.vars.get(ind[i]);
            }
        }
        if (len != null) {
            len[0] = nvars[0];
        }
    }

    public void getGenConstrAbs(GRBGenConstr genc, GRBVar[] resvar, GRBVar[] argvar) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int error = 0;
        int[] resind = new int[1];
        int[] argind = new int[1];
        error = GurobiJni.getgenconstrabs(this.model, genci, resind, argind);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (resvar != null) {
            resvar[0] = this.vars.get(resind[0]);
        }
        if (argvar != null) {
            argvar[0] = this.vars.get(argind[0]);
        }
    }

    public void getGenConstrAnd(GRBGenConstr genc, GRBVar[] resvar, GRBVar[] vars, int[] len) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] resind = new int[1];
        int[] nvars = new int[1];
        int error = GurobiJni.getgenconstrand(this.model, genci, resind, nvars, null);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (resvar != null) {
            resvar[0] = this.vars.get(resind[0]);
        }
        if (vars != null) {
            if (vars.length < nvars[0]) {
                throw new GRBException("Array too short", 10003);
            }
            int[] ind = new int[nvars[0]];
            error = GurobiJni.getgenconstrand(this.model, genci, null, null, ind);
            if (error != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error);
            }
            for (int i = 0; i < nvars[0]; ++i) {
                vars[i] = this.vars.get(ind[i]);
            }
        }
        if (len != null) {
            len[0] = nvars[0];
        }
    }

    public void getGenConstrOr(GRBGenConstr genc, GRBVar[] resvar, GRBVar[] vars, int[] len) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] resind = new int[1];
        int[] nvars = new int[1];
        int error = GurobiJni.getgenconstror(this.model, genci, resind, nvars, null);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (resvar != null) {
            resvar[0] = this.vars.get(resind[0]);
        }
        if (vars != null) {
            if (vars.length < nvars[0]) {
                throw new GRBException("Array too short", 10003);
            }
            int[] ind = new int[nvars[0]];
            error = GurobiJni.getgenconstror(this.model, genci, null, null, ind);
            if (error != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error);
            }
            for (int i = 0; i < nvars[0]; ++i) {
                vars[i] = this.vars.get(ind[i]);
            }
        }
        if (len != null) {
            len[0] = nvars[0];
        }
    }

    public void getGenConstrNorm(GRBGenConstr genc, GRBVar[] resvar, GRBVar[] vars, int[] len, double[] which) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] resind = new int[1];
        int[] nvars = new int[1];
        int error = GurobiJni.getgenconstrnorm(this.model, genci, resind, nvars, null, which);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (resvar != null) {
            resvar[0] = this.vars.get(resind[0]);
        }
        if (vars != null) {
            if (vars.length < nvars[0]) {
                throw new GRBException("Array too short", 10003);
            }
            int[] ind = new int[nvars[0]];
            error = GurobiJni.getgenconstrnorm(this.model, genci, null, null, ind, null);
            if (error != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error);
            }
            for (int i = 0; i < nvars[0]; ++i) {
                vars[i] = this.vars.get(ind[i]);
            }
        }
        if (len != null) {
            len[0] = nvars[0];
        }
    }

    public void getGenConstrIndicator(GRBGenConstr genc, GRBVar[] binvar, int[] binval, GRBLinExpr[] expr, char[] sense, double[] rhs) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] binind = new int[1];
        int[] nvars = new int[1];
        int error = GurobiJni.getgenconstrindicator(this.model, genci, binind, binval, nvars, null, null, sense, rhs);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (binvar != null) {
            binvar[0] = this.vars.get(binind[0]);
        }
        if (expr != null) {
            int[] ind = new int[nvars[0]];
            double[] val = new double[nvars[0]];
            error = GurobiJni.getgenconstrindicator(this.model, genci, null, null, null, ind, val, null, null);
            if (error != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error);
            }
            expr[0] = new GRBLinExpr();
            for (int i = 0; i < nvars[0]; ++i) {
                expr[0].addTerm(val[i], this.vars.get(ind[i]));
            }
        }
    }

    public void getGenConstrPWL(GRBGenConstr genc, GRBVar[] xvar, GRBVar[] yvar, int[] npts, double[] xpts, double[] ypts) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] xind = new int[1];
        int[] yind = new int[1];
        int[] len = new int[1];
        int error = GurobiJni.getgenconstrpwl(this.model, genci, xind, yind, len, xpts, ypts);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (xpts != null && ypts != null && (xpts.length < len[0] || ypts.length < len[0])) {
            throw new GRBException("Array too short", 10003);
        }
        if (npts != null) {
            npts[0] = len[0];
        }
        if (xvar != null) {
            xvar[0] = this.vars.get(xind[0]);
        }
        if (yvar != null) {
            yvar[0] = this.vars.get(yind[0]);
        }
    }

    public void getGenConstrPoly(GRBGenConstr genc, GRBVar[] xvar, GRBVar[] yvar, int[] plen, double[] p) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] xind = new int[1];
        int[] yind = new int[1];
        int[] len = new int[1];
        int error = GurobiJni.getgenconstrpoly(this.model, genci, xind, yind, len, p);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (p != null && p.length < len[0]) {
            throw new GRBException("Array too short", 10003);
        }
        if (plen != null) {
            plen[0] = len[0];
        }
        if (xvar != null) {
            xvar[0] = this.vars.get(xind[0]);
        }
        if (yvar != null) {
            yvar[0] = this.vars.get(yind[0]);
        }
    }

    public void getGenConstrExp(GRBGenConstr genc, GRBVar[] xvar, GRBVar[] yvar) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] xind = new int[1];
        int[] yind = new int[1];
        int error = GurobiJni.getgenconstrexp(this.model, genci, xind, yind);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (xvar != null) {
            xvar[0] = this.vars.get(xind[0]);
        }
        if (yvar != null) {
            yvar[0] = this.vars.get(yind[0]);
        }
    }

    public void getGenConstrExpA(GRBGenConstr genc, GRBVar[] xvar, GRBVar[] yvar, double[] a) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] xind = new int[1];
        int[] yind = new int[1];
        int error = GurobiJni.getgenconstrexpa(this.model, genci, xind, yind, a);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (xvar != null) {
            xvar[0] = this.vars.get(xind[0]);
        }
        if (yvar != null) {
            yvar[0] = this.vars.get(yind[0]);
        }
    }

    public void getGenConstrLog(GRBGenConstr genc, GRBVar[] xvar, GRBVar[] yvar) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] xind = new int[1];
        int[] yind = new int[1];
        int error = GurobiJni.getgenconstrlog(this.model, genci, xind, yind);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (xvar != null) {
            xvar[0] = this.vars.get(xind[0]);
        }
        if (yvar != null) {
            yvar[0] = this.vars.get(yind[0]);
        }
    }

    public void getGenConstrLogA(GRBGenConstr genc, GRBVar[] xvar, GRBVar[] yvar, double[] a) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] xind = new int[1];
        int[] yind = new int[1];
        int error = GurobiJni.getgenconstrloga(this.model, genci, xind, yind, a);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (xvar != null) {
            xvar[0] = this.vars.get(xind[0]);
        }
        if (yvar != null) {
            yvar[0] = this.vars.get(yind[0]);
        }
    }

    public void getGenConstrPow(GRBGenConstr genc, GRBVar[] xvar, GRBVar[] yvar, double[] a) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] xind = new int[1];
        int[] yind = new int[1];
        int error = GurobiJni.getgenconstrpow(this.model, genci, xind, yind, a);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (xvar != null) {
            xvar[0] = this.vars.get(xind[0]);
        }
        if (yvar != null) {
            yvar[0] = this.vars.get(yind[0]);
        }
    }

    public void getGenConstrSin(GRBGenConstr genc, GRBVar[] xvar, GRBVar[] yvar) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] xind = new int[1];
        int[] yind = new int[1];
        int error = GurobiJni.getgenconstrsin(this.model, genci, xind, yind);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (xvar != null) {
            xvar[0] = this.vars.get(xind[0]);
        }
        if (yvar != null) {
            yvar[0] = this.vars.get(yind[0]);
        }
    }

    public void getGenConstrCos(GRBGenConstr genc, GRBVar[] xvar, GRBVar[] yvar) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] xind = new int[1];
        int[] yind = new int[1];
        int error = GurobiJni.getgenconstrcos(this.model, genci, xind, yind);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (xvar != null) {
            xvar[0] = this.vars.get(xind[0]);
        }
        if (yvar != null) {
            yvar[0] = this.vars.get(yind[0]);
        }
    }

    public void getGenConstrTan(GRBGenConstr genc, GRBVar[] xvar, GRBVar[] yvar) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] xind = new int[1];
        int[] yind = new int[1];
        int error = GurobiJni.getgenconstrtan(this.model, genci, xind, yind);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (xvar != null) {
            xvar[0] = this.vars.get(xind[0]);
        }
        if (yvar != null) {
            yvar[0] = this.vars.get(yind[0]);
        }
    }

    public void getGenConstrLogistic(GRBGenConstr genc, GRBVar[] xvar, GRBVar[] yvar) throws GRBException {
        int genci = genc.getindex();
        if (genci < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] xind = new int[1];
        int[] yind = new int[1];
        int error = GurobiJni.getgenconstrlogistic(this.model, genci, xind, yind);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        if (xvar != null) {
            xvar[0] = this.vars.get(xind[0]);
        }
        if (yvar != null) {
            yvar[0] = this.vars.get(yind[0]);
        }
    }

    public GRBQuadExpr getQCRow(GRBQConstr qc) throws GRBException {
        int i;
        int error = 0;
        int qconstr = qc.getindex();
        if (qconstr < 0) {
            throw new GRBException("Not in the model", 20001);
        }
        int[] lnz = new int[1];
        int[] qnz = new int[]{0};
        lnz[0] = 0;
        error = GurobiJni.getqconstr(this.model, qconstr, lnz, null, null, qnz, null, null, null);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        int[] lind = new int[lnz[0]];
        double[] lval = new double[lnz[0]];
        int[] qrow = new int[qnz[0]];
        int[] qcol = new int[qnz[0]];
        double[] qval = new double[qnz[0]];
        error = GurobiJni.getqconstr(this.model, qconstr, lnz, lind, lval, qnz, qrow, qcol, qval);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        GRBQuadExpr qe = new GRBQuadExpr();
        for (i = 0; i < lnz[0]; ++i) {
            qe.addTerm(lval[i], this.vars.get(lind[i]));
        }
        for (i = 0; i < qnz[0]; ++i) {
            qe.addTerm(qval[i], this.vars.get(qrow[i]), this.vars.get(qcol[i]));
        }
        return qe;
    }

    public void remove(GRBSOS sos) throws GRBException {
        int sosi = sos.getindex();
        if (sosi >= 0) {
            sosi = -3 - sosi;
        } else if (sosi == -1) {
            throw new GRBException("Not in the model for removing", 20001);
        }
        sos.setindex(sosi);
    }

    public void remove(GRBQConstr qconstr) throws GRBException {
        int qconstri = qconstr.getindex();
        if (qconstri >= 0) {
            qconstri = -3 - qconstri;
        } else if (qconstri == -1) {
            throw new GRBException("Not in the model for removing", 20001);
        }
        qconstr.setindex(qconstri);
    }

    public void remove(GRBGenConstr genconstr) throws GRBException {
        int genconstri = genconstr.getindex();
        if (genconstri >= 0) {
            genconstri = -3 - genconstri;
        } else if (genconstri == -1) {
            throw new GRBException("Not in the model for removing", 20001);
        }
        genconstr.setindex(genconstri);
    }

    public GRBEnv getEnv() throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        return new GRBEnv(this.env);
    }

    public GRBEnv getConcurrentEnv(int num) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        long cenv = GurobiJni.getconcurrentenv(this.model, num);
        if (cenv == 0L) {
            throw new GRBException("Failed to create concurrent env", 10003);
        }
        return new GRBEnv(cenv);
    }

    public void discardConcurrentEnvs() throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        GurobiJni.discardconcurrentenvs(this.model);
    }

    public String getJSONSolution() throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        String[] value = new String[1];
        int error = GurobiJni.getJSONSolution(this.model, value);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return value[0];
    }

    public GRBEnv getMultiobjEnv(int index) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        long cenv = GurobiJni.getmultiobjenv(this.model, index);
        if (cenv == 0L) {
            throw new GRBException("Failed to create multiobj env", 10003);
        }
        return new GRBEnv(cenv);
    }

    public void discardMultiobjEnvs() throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        GurobiJni.discardmultiobjenvs(this.model);
    }

    public void fixTuneParam(GRB.IntParam param) throws GRBException {
        this.fixTuneParam(param.toString());
    }

    public void fixTuneParam(GRB.DoubleParam param) throws GRBException {
        this.fixTuneParam(param.toString());
    }

    public void fixTuneParam(GRB.StringParam param) throws GRBException {
        this.fixTuneParam(param.toString());
    }

    public void fixTuneParam(String param) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int error = GurobiJni.fixtuneparam(this.env, param);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public int get(GRB.IntParam param) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int[] value = new int[1];
        int error = GurobiJni.getintparam(this.env, param.toString(), value);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return value[0];
    }

    public double get(GRB.DoubleParam param) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        double[] value = new double[1];
        int error = GurobiJni.getdblparam(this.env, param.toString(), value);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return value[0];
    }

    public String get(GRB.StringParam param) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        String[] value = new String[1];
        int error = GurobiJni.getstrparam(this.env, param.toString(), value);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return value[0];
    }

    public void set(GRB.IntParam param, int newval) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int error = GurobiJni.setintparam(this.env, param.toString(), newval);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void set(GRB.DoubleParam param, double newval) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int error = GurobiJni.setdblparam(this.env, param.toString(), newval);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void set(GRB.StringParam param, String newval) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int error = GurobiJni.setstrparam(this.env, param.toString(), newval);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void set(String param, String newval) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int error = GurobiJni.setparam(this.env, param, newval);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public int get(GRB.IntAttr attr) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int[] ind = new int[1];
        int[] val = new int[1];
        int error = GurobiJni.getintattrlist(this.model, attr.toString(), 0, -1, ind, val);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return val[0];
    }

    public double get(GRB.DoubleAttr attr) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int[] ind = new int[1];
        double[] val = new double[1];
        int error = GurobiJni.getdblattrlist(this.model, attr.toString(), 0, -1, ind, val);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return val[0];
    }

    public String get(GRB.StringAttr attr) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int[] ind = new int[1];
        String[] val = new String[1];
        int error = GurobiJni.getstrattrlist(this.model, attr.toString(), 0, -1, ind, val);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return val[0];
    }

    public void set(GRB.IntAttr attr, int newval) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int[] ind = new int[1];
        int[] val = new int[]{newval};
        int error = GurobiJni.setintattrlist(this.model, attr.toString(), 0, -1, ind, val);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void set(GRB.DoubleAttr attr, double newval) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int[] ind = new int[1];
        double[] val = new double[]{newval};
        int error = GurobiJni.setdblattrlist(this.model, attr.toString(), 0, -1, ind, val);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void set(GRB.StringAttr attr, String newval) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int[] ind = new int[1];
        String[] val = new String[]{newval};
        int error = GurobiJni.setstrattrlist(this.model, attr.toString(), 0, -1, ind, val);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public int[] get(GRB.IntAttr attr, GRBVar[] vars) throws GRBException {
        int[] values = new int[vars.length];
        this.getattr(attr.toString(), vars, values, 1, 0, 0);
        return values;
    }

    public char[] get(GRB.CharAttr attr, GRBVar[] vars) throws GRBException {
        char[] values = new char[vars.length];
        this.getattr(attr.toString(), vars, values, 1, 0, 1);
        return values;
    }

    public double[] get(GRB.DoubleAttr attr, GRBVar[] vars) throws GRBException {
        double[] values = new double[vars.length];
        this.getattr(attr.toString(), vars, values, 1, 0, 2);
        return values;
    }

    public String[] get(GRB.StringAttr attr, GRBVar[] vars) throws GRBException {
        String[] values = new String[vars.length];
        this.getattr(attr.toString(), vars, values, 1, 0, 3);
        return values;
    }

    public int[] get(GRB.IntAttr attr, GRBVar[] vars, int start, int len) throws GRBException {
        GRBVar[] vars1 = this.subArray(vars, start, len);
        int[] values = new int[len];
        this.getattr(attr.toString(), vars1, values, 1, 0, 0);
        return values;
    }

    public char[] get(GRB.CharAttr attr, GRBVar[] vars, int start, int len) throws GRBException {
        GRBVar[] vars1 = this.subArray(vars, start, len);
        char[] values = new char[len];
        this.getattr(attr.toString(), vars1, values, 1, 0, 1);
        return values;
    }

    public double[] get(GRB.DoubleAttr attr, GRBVar[] vars, int start, int len) throws GRBException {
        GRBVar[] vars1 = this.subArray(vars, start, len);
        double[] values = new double[len];
        this.getattr(attr.toString(), vars1, values, 1, 0, 2);
        return values;
    }

    public String[] get(GRB.StringAttr attr, GRBVar[] vars, int start, int len) throws GRBException {
        GRBVar[] vars1 = this.subArray(vars, start, len);
        String[] values = new String[len];
        this.getattr(attr.toString(), vars1, values, 1, 0, 3);
        return values;
    }

    public int[][] get(GRB.IntAttr attr, GRBVar[][] vars) throws GRBException {
        int result = this.checkdim2(vars);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = vars.length;
        int len1 = vars[0].length;
        int[][] values = new int[len][len1];
        this.getattr(attr.toString(), vars, values, 2, 0, 0);
        return values;
    }

    public char[][] get(GRB.CharAttr attr, GRBVar[][] vars) throws GRBException {
        int result = this.checkdim2(vars);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = vars.length;
        int len1 = vars[0].length;
        char[][] values = new char[len][len1];
        this.getattr(attr.toString(), vars, values, 2, 0, 1);
        return values;
    }

    public double[][] get(GRB.DoubleAttr attr, GRBVar[][] vars) throws GRBException {
        int result = this.checkdim2(vars);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = vars.length;
        int len1 = vars[0].length;
        double[][] values = new double[len][len1];
        this.getattr(attr.toString(), vars, values, 2, 0, 2);
        return values;
    }

    public String[][] get(GRB.StringAttr attr, GRBVar[][] vars) throws GRBException {
        int result = this.checkdim2(vars);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = vars.length;
        int len1 = vars[0].length;
        String[][] values = new String[len][len1];
        this.getattr(attr.toString(), vars, values, 2, 0, 3);
        return values;
    }

    public int[][][] get(GRB.IntAttr attr, GRBVar[][][] vars) throws GRBException {
        int result = this.checkdim3(vars);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = vars.length;
        int len1 = vars[0].length;
        int len2 = vars[0][0].length;
        int[][][] values = new int[len][len1][len2];
        this.getattr(attr.toString(), vars, values, 3, 0, 0);
        return values;
    }

    public char[][][] get(GRB.CharAttr attr, GRBVar[][][] vars) throws GRBException {
        int result = this.checkdim3(vars);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = vars.length;
        int len1 = vars[0].length;
        int len2 = vars[0][0].length;
        char[][][] values = new char[len][len1][len2];
        this.getattr(attr.toString(), vars, values, 3, 0, 1);
        return values;
    }

    public double[][][] get(GRB.DoubleAttr attr, GRBVar[][][] vars) throws GRBException {
        int result = this.checkdim3(vars);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = vars.length;
        int len1 = vars[0].length;
        int len2 = vars[0][0].length;
        double[][][] values = new double[len][len1][len2];
        this.getattr(attr.toString(), vars, values, 3, 0, 2);
        return values;
    }

    public String[][][] get(GRB.StringAttr attr, GRBVar[][][] vars) throws GRBException {
        int result = this.checkdim3(vars);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = vars.length;
        int len1 = vars[0].length;
        int len2 = vars[0][0].length;
        String[][][] values = new String[len][len1][len2];
        this.getattr(attr.toString(), vars, values, 3, 0, 3);
        return values;
    }

    public int[] get(GRB.IntAttr attr, GRBConstr[] constrs) throws GRBException {
        int[] values = new int[constrs.length];
        this.getattr(attr.toString(), constrs, values, 1, 1, 0);
        return values;
    }

    public char[] get(GRB.CharAttr attr, GRBConstr[] constrs) throws GRBException {
        char[] values = new char[constrs.length];
        this.getattr(attr.toString(), constrs, values, 1, 1, 1);
        return values;
    }

    public double[] get(GRB.DoubleAttr attr, GRBConstr[] constrs) throws GRBException {
        double[] values = new double[constrs.length];
        this.getattr(attr.toString(), constrs, values, 1, 1, 2);
        return values;
    }

    public String[] get(GRB.StringAttr attr, GRBConstr[] constrs) throws GRBException {
        String[] values = new String[constrs.length];
        this.getattr(attr.toString(), constrs, values, 1, 1, 3);
        return values;
    }

    public int[] get(GRB.IntAttr attr, GRBConstr[] constrs, int start, int len) throws GRBException {
        GRBConstr[] constrs1 = this.subArray(constrs, start, len);
        int[] values = new int[len];
        this.getattr(attr.toString(), constrs1, values, 1, 1, 0);
        return values;
    }

    public char[] get(GRB.CharAttr attr, GRBConstr[] constrs, int start, int len) throws GRBException {
        GRBConstr[] constrs1 = this.subArray(constrs, start, len);
        char[] values = new char[len];
        this.getattr(attr.toString(), constrs1, values, 1, 1, 1);
        return values;
    }

    public double[] get(GRB.DoubleAttr attr, GRBConstr[] constrs, int start, int len) throws GRBException {
        GRBConstr[] constrs1 = this.subArray(constrs, start, len);
        double[] values = new double[len];
        this.getattr(attr.toString(), constrs1, values, 1, 1, 2);
        return values;
    }

    public String[] get(GRB.StringAttr attr, GRBConstr[] constrs, int start, int len) throws GRBException {
        GRBConstr[] constrs1 = this.subArray(constrs, start, len);
        String[] values = new String[len];
        this.getattr(attr.toString(), constrs1, values, 1, 1, 3);
        return values;
    }

    public int[][] get(GRB.IntAttr attr, GRBConstr[][] constrs) throws GRBException {
        int result = this.checkdim2(constrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = constrs.length;
        int len1 = constrs[0].length;
        int[][] values = new int[len][len1];
        this.getattr(attr.toString(), constrs, values, 2, 1, 0);
        return values;
    }

    public char[][] get(GRB.CharAttr attr, GRBConstr[][] constrs) throws GRBException {
        int result = this.checkdim2(constrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = constrs.length;
        int len1 = constrs[0].length;
        char[][] values = new char[len][len1];
        this.getattr(attr.toString(), constrs, values, 2, 1, 1);
        return values;
    }

    public double[][] get(GRB.DoubleAttr attr, GRBConstr[][] constrs) throws GRBException {
        int result = this.checkdim2(constrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = constrs.length;
        int len1 = constrs[0].length;
        double[][] values = new double[len][len1];
        this.getattr(attr.toString(), constrs, values, 2, 1, 2);
        return values;
    }

    public String[][] get(GRB.StringAttr attr, GRBConstr[][] constrs) throws GRBException {
        int result = this.checkdim2(constrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = constrs.length;
        int len1 = constrs[0].length;
        String[][] values = new String[len][len1];
        this.getattr(attr.toString(), constrs, values, 2, 1, 3);
        return values;
    }

    public int[][][] get(GRB.IntAttr attr, GRBConstr[][][] constrs) throws GRBException {
        int result = this.checkdim3(constrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = constrs.length;
        int len1 = constrs[0].length;
        int len2 = constrs[0][0].length;
        int[][][] values = new int[len][len1][len2];
        this.getattr(attr.toString(), constrs, values, 3, 1, 0);
        return values;
    }

    public char[][][] get(GRB.CharAttr attr, GRBConstr[][][] constrs) throws GRBException {
        int result = this.checkdim3(constrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = constrs.length;
        int len1 = constrs[0].length;
        int len2 = constrs[0][0].length;
        char[][][] values = new char[len][len1][len2];
        this.getattr(attr.toString(), constrs, values, 3, 1, 1);
        return values;
    }

    public double[][][] get(GRB.DoubleAttr attr, GRBConstr[][][] constrs) throws GRBException {
        int result = this.checkdim3(constrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = constrs.length;
        int len1 = constrs[0].length;
        int len2 = constrs[0][0].length;
        double[][][] values = new double[len][len1][len2];
        this.getattr(attr.toString(), constrs, values, 3, 1, 2);
        return values;
    }

    public String[][][] get(GRB.StringAttr attr, GRBConstr[][][] constrs) throws GRBException {
        int result = this.checkdim3(constrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = constrs.length;
        int len1 = constrs[0].length;
        int len2 = constrs[0][0].length;
        String[][][] values = new String[len][len1][len2];
        this.getattr(attr.toString(), constrs, values, 3, 1, 3);
        return values;
    }

    public int[] get(GRB.IntAttr attr, GRBQConstr[] qconstrs) throws GRBException {
        int[] values = new int[qconstrs.length];
        this.getattr(attr.toString(), qconstrs, values, 1, 3, 0);
        return values;
    }

    public char[] get(GRB.CharAttr attr, GRBQConstr[] qconstrs) throws GRBException {
        char[] values = new char[qconstrs.length];
        this.getattr(attr.toString(), qconstrs, values, 1, 3, 1);
        return values;
    }

    public double[] get(GRB.DoubleAttr attr, GRBQConstr[] qconstrs) throws GRBException {
        double[] values = new double[qconstrs.length];
        this.getattr(attr.toString(), qconstrs, values, 1, 3, 2);
        return values;
    }

    public String[] get(GRB.StringAttr attr, GRBQConstr[] qconstrs) throws GRBException {
        String[] values = new String[qconstrs.length];
        this.getattr(attr.toString(), qconstrs, values, 1, 3, 3);
        return values;
    }

    public int[] get(GRB.IntAttr attr, GRBQConstr[] qconstrs, int start, int len) throws GRBException {
        GRBQConstr[] qconstrs1 = this.subArray(qconstrs, start, len);
        int[] values = new int[len];
        this.getattr(attr.toString(), qconstrs1, values, 1, 3, 0);
        return values;
    }

    public char[] get(GRB.CharAttr attr, GRBQConstr[] qconstrs, int start, int len) throws GRBException {
        GRBQConstr[] qconstrs1 = this.subArray(qconstrs, start, len);
        char[] values = new char[len];
        this.getattr(attr.toString(), qconstrs1, values, 1, 3, 1);
        return values;
    }

    public double[] get(GRB.DoubleAttr attr, GRBQConstr[] qconstrs, int start, int len) throws GRBException {
        GRBQConstr[] qconstrs1 = this.subArray(qconstrs, start, len);
        double[] values = new double[len];
        this.getattr(attr.toString(), qconstrs1, values, 1, 3, 2);
        return values;
    }

    public String[] get(GRB.StringAttr attr, GRBQConstr[] qconstrs, int start, int len) throws GRBException {
        GRBQConstr[] qconstrs1 = this.subArray(qconstrs, start, len);
        String[] values = new String[len];
        this.getattr(attr.toString(), qconstrs1, values, 1, 3, 3);
        return values;
    }

    public int[][] get(GRB.IntAttr attr, GRBQConstr[][] qconstrs) throws GRBException {
        int result = this.checkdim2(qconstrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = qconstrs.length;
        int len1 = qconstrs[0].length;
        int[][] values = new int[len][len1];
        this.getattr(attr.toString(), qconstrs, values, 2, 3, 0);
        return values;
    }

    public char[][] get(GRB.CharAttr attr, GRBQConstr[][] qconstrs) throws GRBException {
        int result = this.checkdim2(qconstrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = qconstrs.length;
        int len1 = qconstrs[0].length;
        char[][] values = new char[len][len1];
        this.getattr(attr.toString(), qconstrs, values, 2, 3, 1);
        return values;
    }

    public double[][] get(GRB.DoubleAttr attr, GRBQConstr[][] qconstrs) throws GRBException {
        int result = this.checkdim2(qconstrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = qconstrs.length;
        int len1 = qconstrs[0].length;
        double[][] values = new double[len][len1];
        this.getattr(attr.toString(), qconstrs, values, 2, 3, 2);
        return values;
    }

    public String[][] get(GRB.StringAttr attr, GRBQConstr[][] qconstrs) throws GRBException {
        int result = this.checkdim2(qconstrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = qconstrs.length;
        int len1 = qconstrs[0].length;
        String[][] values = new String[len][len1];
        this.getattr(attr.toString(), qconstrs, values, 2, 3, 3);
        return values;
    }

    public int[][][] get(GRB.IntAttr attr, GRBQConstr[][][] qconstrs) throws GRBException {
        int result = this.checkdim3(qconstrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = qconstrs.length;
        int len1 = qconstrs[0].length;
        int len2 = qconstrs[0][0].length;
        int[][][] values = new int[len][len1][len2];
        this.getattr(attr.toString(), qconstrs, values, 3, 3, 0);
        return values;
    }

    public char[][][] get(GRB.CharAttr attr, GRBQConstr[][][] qconstrs) throws GRBException {
        int result = this.checkdim3(qconstrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = qconstrs.length;
        int len1 = qconstrs[0].length;
        int len2 = qconstrs[0][0].length;
        char[][][] values = new char[len][len1][len2];
        this.getattr(attr.toString(), qconstrs, values, 3, 3, 1);
        return values;
    }

    public double[][][] get(GRB.DoubleAttr attr, GRBQConstr[][][] qconstrs) throws GRBException {
        int result = this.checkdim3(qconstrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = qconstrs.length;
        int len1 = qconstrs[0].length;
        int len2 = qconstrs[0][0].length;
        double[][][] values = new double[len][len1][len2];
        this.getattr(attr.toString(), qconstrs, values, 3, 3, 2);
        return values;
    }

    public String[][][] get(GRB.StringAttr attr, GRBQConstr[][][] qconstrs) throws GRBException {
        int result = this.checkdim3(qconstrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = qconstrs.length;
        int len1 = qconstrs[0].length;
        int len2 = qconstrs[0][0].length;
        String[][][] values = new String[len][len1][len2];
        this.getattr(attr.toString(), qconstrs, values, 3, 3, 3);
        return values;
    }

    public int[] get(GRB.IntAttr attr, GRBGenConstr[] genconstrs) throws GRBException {
        int[] values = new int[genconstrs.length];
        this.getattr(attr.toString(), genconstrs, values, 1, 4, 0);
        return values;
    }

    public String[] get(GRB.StringAttr attr, GRBGenConstr[] genconstrs) throws GRBException {
        String[] values = new String[genconstrs.length];
        this.getattr(attr.toString(), genconstrs, values, 1, 4, 3);
        return values;
    }

    public int[] get(GRB.IntAttr attr, GRBGenConstr[] genconstrs, int start, int len) throws GRBException {
        GRBGenConstr[] genconstrs1 = this.subArray(genconstrs, start, len);
        int[] values = new int[len];
        this.getattr(attr.toString(), genconstrs1, values, 1, 4, 0);
        return values;
    }

    public String[] get(GRB.StringAttr attr, GRBGenConstr[] genconstrs, int start, int len) throws GRBException {
        GRBGenConstr[] genconstrs1 = this.subArray(genconstrs, start, len);
        String[] values = new String[len];
        this.getattr(attr.toString(), genconstrs1, values, 1, 4, 3);
        return values;
    }

    public int[][] get(GRB.IntAttr attr, GRBGenConstr[][] genconstrs) throws GRBException {
        int result = this.checkdim2(genconstrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = genconstrs.length;
        int len1 = genconstrs[0].length;
        int[][] values = new int[len][len1];
        this.getattr(attr.toString(), genconstrs, values, 2, 4, 0);
        return values;
    }

    public String[][] get(GRB.StringAttr attr, GRBGenConstr[][] genconstrs) throws GRBException {
        int result = this.checkdim2(genconstrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = genconstrs.length;
        int len1 = genconstrs[0].length;
        String[][] values = new String[len][len1];
        this.getattr(attr.toString(), genconstrs, values, 2, 4, 3);
        return values;
    }

    public int[][][] get(GRB.IntAttr attr, GRBGenConstr[][][] genconstrs) throws GRBException {
        int result = this.checkdim3(genconstrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = genconstrs.length;
        int len1 = genconstrs[0].length;
        int len2 = genconstrs[0][0].length;
        int[][][] values = new int[len][len1][len2];
        this.getattr(attr.toString(), genconstrs, values, 3, 4, 0);
        return values;
    }

    public String[][][] get(GRB.StringAttr attr, GRBGenConstr[][][] genconstrs) throws GRBException {
        int result = this.checkdim3(genconstrs);
        if (result == 1) {
            return null;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        int len = genconstrs.length;
        int len1 = genconstrs[0].length;
        int len2 = genconstrs[0][0].length;
        String[][][] values = new String[len][len1][len2];
        this.getattr(attr.toString(), genconstrs, values, 3, 4, 3);
        return values;
    }

    public void set(GRB.IntAttr attr, GRBVar[] vars, int[] newvals) throws GRBException {
        if (vars == null || newvals == null || vars.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), vars, newvals, 1, 0, 0);
    }

    public void set(GRB.CharAttr attr, GRBVar[] vars, char[] newvals) throws GRBException {
        if (vars == null || newvals == null || vars.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), vars, newvals, 1, 0, 1);
    }

    public void set(GRB.DoubleAttr attr, GRBVar[] vars, double[] newvals) throws GRBException {
        if (vars == null || newvals == null || vars.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), vars, newvals, 1, 0, 2);
    }

    public void set(GRB.StringAttr attr, GRBVar[] vars, String[] newvals) throws GRBException {
        if (vars == null || newvals == null || vars.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), vars, newvals, 1, 0, 3);
    }

    public void set(GRB.IntAttr attr, GRBVar[] vars, int[] newvals, int start, int len) throws GRBException {
        if (vars == null || newvals == null || vars.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), this.subArray(vars, start, len), this.subArray(newvals, start, len), 1, 0, 0);
    }

    public void set(GRB.CharAttr attr, GRBVar[] vars, char[] newvals, int start, int len) throws GRBException {
        if (vars == null || newvals == null || vars.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), this.subArray(vars, start, len), this.subArray(newvals, start, len), 1, 0, 1);
    }

    public void set(GRB.DoubleAttr attr, GRBVar[] vars, double[] newvals, int start, int len) throws GRBException {
        if (vars == null || newvals == null || vars.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), this.subArray(vars, start, len), this.subArray(newvals, start, len), 1, 0, 2);
    }

    public void set(GRB.StringAttr attr, GRBVar[] vars, String[] newvals, int start, int len) throws GRBException {
        if (vars == null || newvals == null || vars.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), this.subArray(vars, start, len), this.subArray(newvals, start, len), 1, 0, 3);
    }

    public void set(GRB.IntAttr attr, GRBVar[][] vars, int[][] newvals) throws GRBException {
        int result = this.checkdim2(vars);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        result = this.checkdim2(newvals);
        if (this.samedim2((Object[][])vars, newvals)) {
            result = 1;
        }
        if (result != 0) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), vars, newvals, 2, 0, 0);
    }

    public void set(GRB.CharAttr attr, GRBVar[][] vars, char[][] newvals) throws GRBException {
        int result = this.checkdim2(vars);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        result = this.checkdim2(newvals);
        if (this.samedim2((Object[][])vars, newvals)) {
            result = 1;
        }
        if (result != 0) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), vars, newvals, 2, 0, 1);
    }

    public void set(GRB.DoubleAttr attr, GRBVar[][] vars, double[][] newvals) throws GRBException {
        int result = this.checkdim2(vars);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        result = this.checkdim2(newvals);
        if (this.samedim2((Object[][])vars, newvals)) {
            result = 1;
        }
        if (result != 0) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), vars, newvals, 2, 0, 2);
    }

    public void set(GRB.StringAttr attr, GRBVar[][] vars, String[][] newvals) throws GRBException {
        int result = this.checkdim2(vars);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        result = this.checkdim2(newvals);
        if (this.samedim2((Object[][])vars, newvals)) {
            result = 1;
        }
        if (result != 0) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), vars, newvals, 2, 0, 3);
    }

    public void set(GRB.IntAttr attr, GRBVar[][][] vars, int[][][] newvals) throws GRBException {
        int result = this.checkdim3(vars);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        result = this.checkdim3(newvals);
        if (this.samedim3((Object[][][])vars, newvals)) {
            result = 1;
        }
        if (result != 0) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), vars, newvals, 3, 0, 0);
    }

    public void set(GRB.CharAttr attr, GRBVar[][][] vars, char[][][] newvals) throws GRBException {
        int result = this.checkdim3(vars);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        result = this.checkdim3(newvals);
        if (this.samedim3((Object[][][])vars, newvals)) {
            result = 1;
        }
        if (result != 0) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), vars, newvals, 3, 0, 1);
    }

    public void set(GRB.DoubleAttr attr, GRBVar[][][] vars, double[][][] newvals) throws GRBException {
        int result = this.checkdim3(vars);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        result = this.checkdim3(newvals);
        if (this.samedim3((Object[][][])vars, newvals)) {
            result = 1;
        }
        if (result != 0) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), vars, newvals, 3, 0, 2);
    }

    public void set(GRB.StringAttr attr, GRBVar[][][] vars, String[][][] newvals) throws GRBException {
        int result = this.checkdim3(vars);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        result = this.checkdim3(newvals);
        if (this.samedim3((Object[][][])vars, newvals)) {
            result = 1;
        }
        if (result != 0) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), vars, newvals, 3, 0, 3);
    }

    public void set(GRB.IntAttr attr, GRBConstr[] constrs, int[] newvals) throws GRBException {
        if (constrs == null || newvals == null || constrs.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), constrs, newvals, 1, 1, 0);
    }

    public void set(GRB.CharAttr attr, GRBConstr[] constrs, char[] newvals) throws GRBException {
        if (constrs == null || newvals == null || constrs.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), constrs, newvals, 1, 1, 1);
    }

    public void set(GRB.DoubleAttr attr, GRBConstr[] constrs, double[] newvals) throws GRBException {
        if (constrs == null || newvals == null || constrs.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), constrs, newvals, 1, 1, 2);
    }

    public void set(GRB.StringAttr attr, GRBConstr[] constrs, String[] newvals) throws GRBException {
        if (constrs == null || newvals == null || constrs.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), constrs, newvals, 1, 1, 3);
    }

    public void set(GRB.IntAttr attr, GRBConstr[] constrs, int[] newvals, int start, int len) throws GRBException {
        if (constrs == null || newvals == null || constrs.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), this.subArray(constrs, start, len), this.subArray(newvals, start, len), 1, 1, 0);
    }

    public void set(GRB.CharAttr attr, GRBConstr[] constrs, char[] newvals, int start, int len) throws GRBException {
        if (constrs == null || newvals == null || constrs.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), this.subArray(constrs, start, len), this.subArray(newvals, start, len), 1, 1, 1);
    }

    public void set(GRB.DoubleAttr attr, GRBConstr[] constrs, double[] newvals, int start, int len) throws GRBException {
        if (constrs == null || newvals == null || constrs.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), this.subArray(constrs, start, len), this.subArray(newvals, start, len), 1, 1, 2);
    }

    public void set(GRB.StringAttr attr, GRBConstr[] constrs, String[] newvals, int start, int len) throws GRBException {
        if (constrs == null || newvals == null || constrs.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), this.subArray(constrs, start, len), this.subArray(newvals, start, len), 1, 1, 3);
    }

    public void set(GRB.IntAttr attr, GRBConstr[][] constrs, int[][] newvals) throws GRBException {
        int result = this.checkdim2(constrs);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        if (this.checkdim2(newvals) != 0 || !this.samedim2((Object[][])constrs, newvals)) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), constrs, newvals, 2, 1, 0);
    }

    public void set(GRB.CharAttr attr, GRBConstr[][] constrs, char[][] newvals) throws GRBException {
        int result = this.checkdim2(constrs);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        if (this.checkdim2(newvals) != 0 || !this.samedim2((Object[][])constrs, newvals)) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), constrs, newvals, 2, 1, 1);
    }

    public void set(GRB.DoubleAttr attr, GRBConstr[][] constrs, double[][] newvals) throws GRBException {
        int result = this.checkdim2(constrs);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        if (this.checkdim2(newvals) != 0 || !this.samedim2((Object[][])constrs, newvals)) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), constrs, newvals, 2, 1, 2);
    }

    public void set(GRB.StringAttr attr, GRBConstr[][] constrs, String[][] newvals) throws GRBException {
        int result = this.checkdim2(constrs);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        if (this.checkdim2(newvals) != 0 || !this.samedim2((Object[][])constrs, newvals)) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), constrs, newvals, 2, 1, 3);
    }

    public void set(GRB.IntAttr attr, GRBConstr[][][] constrs, int[][][] newvals) throws GRBException {
        int result = this.checkdim3(constrs);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        if (this.checkdim2((Object[][])newvals) != 0 || !this.samedim3((Object[][][])constrs, newvals)) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), constrs, newvals, 3, 1, 0);
    }

    public void set(GRB.CharAttr attr, GRBConstr[][][] constrs, char[][][] newvals) throws GRBException {
        int result = this.checkdim3(constrs);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        if (this.checkdim2((Object[][])newvals) != 0 || !this.samedim3((Object[][][])constrs, newvals)) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), constrs, newvals, 3, 1, 1);
    }

    public void set(GRB.DoubleAttr attr, GRBConstr[][][] constrs, double[][][] newvals) throws GRBException {
        int result = this.checkdim3(constrs);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        if (this.checkdim2((Object[][])newvals) != 0 || !this.samedim3((Object[][][])constrs, newvals)) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), constrs, newvals, 3, 1, 2);
    }

    public void set(GRB.StringAttr attr, GRBConstr[][][] constrs, String[][][] newvals) throws GRBException {
        int result = this.checkdim3(constrs);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        if (this.checkdim2((Object[][])newvals) != 0 || !this.samedim3((Object[][][])constrs, newvals)) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), constrs, newvals, 3, 1, 3);
    }

    public void set(GRB.CharAttr attr, GRBQConstr[] qconstrs, char[] newvals) throws GRBException {
        if (qconstrs == null || newvals == null || qconstrs.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), qconstrs, newvals, 1, 3, 1);
    }

    public void set(GRB.DoubleAttr attr, GRBQConstr[] qconstrs, double[] newvals) throws GRBException {
        if (qconstrs == null || newvals == null || qconstrs.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), qconstrs, newvals, 1, 3, 2);
    }

    public void set(GRB.StringAttr attr, GRBQConstr[] qconstrs, String[] newvals) throws GRBException {
        if (qconstrs == null || newvals == null || qconstrs.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), qconstrs, newvals, 1, 3, 3);
    }

    public void set(GRB.CharAttr attr, GRBQConstr[] qconstrs, char[] newvals, int start, int len) throws GRBException {
        if (qconstrs == null || newvals == null || qconstrs.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), this.subArray(qconstrs, start, len), this.subArray(newvals, start, len), 1, 3, 1);
    }

    public void set(GRB.DoubleAttr attr, GRBQConstr[] qconstrs, double[] newvals, int start, int len) throws GRBException {
        if (qconstrs == null || newvals == null || qconstrs.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), this.subArray(qconstrs, start, len), this.subArray(newvals, start, len), 1, 3, 2);
    }

    public void set(GRB.StringAttr attr, GRBQConstr[] qconstrs, String[] newvals, int start, int len) throws GRBException {
        if (qconstrs == null || newvals == null || qconstrs.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), this.subArray(qconstrs, start, len), this.subArray(newvals, start, len), 1, 3, 3);
    }

    public void set(GRB.CharAttr attr, GRBQConstr[][] qconstrs, char[][] newvals) throws GRBException {
        int result = this.checkdim2(qconstrs);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        if (this.checkdim2(newvals) != 0 || !this.samedim2((Object[][])qconstrs, newvals)) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), qconstrs, newvals, 2, 3, 1);
    }

    public void set(GRB.DoubleAttr attr, GRBQConstr[][] qconstrs, double[][] newvals) throws GRBException {
        int result = this.checkdim2(qconstrs);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        if (this.checkdim2(newvals) != 0 || !this.samedim2((Object[][])qconstrs, newvals)) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), qconstrs, newvals, 2, 3, 2);
    }

    public void set(GRB.StringAttr attr, GRBQConstr[][] qconstrs, String[][] newvals) throws GRBException {
        int result = this.checkdim2(qconstrs);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        if (this.checkdim2(newvals) != 0 || !this.samedim2((Object[][])qconstrs, newvals)) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), qconstrs, newvals, 2, 3, 3);
    }

    public void set(GRB.CharAttr attr, GRBQConstr[][][] qconstrs, char[][][] newvals) throws GRBException {
        int result = this.checkdim3(qconstrs);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        if (this.checkdim2((Object[][])newvals) != 0 || !this.samedim3((Object[][][])qconstrs, newvals)) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), qconstrs, newvals, 3, 3, 1);
    }

    public void set(GRB.DoubleAttr attr, GRBQConstr[][][] qconstrs, double[][][] newvals) throws GRBException {
        int result = this.checkdim3(qconstrs);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        if (this.checkdim2((Object[][])newvals) != 0 || !this.samedim3((Object[][][])qconstrs, newvals)) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), qconstrs, newvals, 3, 3, 2);
    }

    public void set(GRB.StringAttr attr, GRBQConstr[][][] qconstrs, String[][][] newvals) throws GRBException {
        int result = this.checkdim3(qconstrs);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        if (this.checkdim2((Object[][])newvals) != 0 || !this.samedim3((Object[][][])qconstrs, newvals)) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), qconstrs, newvals, 3, 3, 3);
    }

    public void set(GRB.StringAttr attr, GRBGenConstr[] genconstrs, String[] newvals) throws GRBException {
        if (genconstrs == null || newvals == null || genconstrs.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), genconstrs, newvals, 1, 4, 3);
    }

    public void set(GRB.StringAttr attr, GRBGenConstr[] genconstrs, String[] newvals, int start, int len) throws GRBException {
        if (genconstrs == null || newvals == null || genconstrs.length > newvals.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        this.setattr(attr.toString(), this.subArray(genconstrs, start, len), this.subArray(newvals, start, len), 1, 4, 3);
    }

    public void set(GRB.StringAttr attr, GRBGenConstr[][] genconstrs, String[][] newvals) throws GRBException {
        int result = this.checkdim2(genconstrs);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        if (this.checkdim2(newvals) != 0 || !this.samedim2((Object[][])genconstrs, newvals)) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), genconstrs, newvals, 2, 4, 3);
    }

    public void set(GRB.StringAttr attr, GRBGenConstr[][][] genconstrs, String[][][] newvals) throws GRBException {
        int result = this.checkdim3(genconstrs);
        if (result == 1) {
            return;
        }
        if (result == 2) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        if (this.checkdim2((Object[][])newvals) != 0 || !this.samedim3((Object[][][])genconstrs, newvals)) {
            throw new GRBException("Wrong array dimensions", 10003);
        }
        this.setattr(attr.toString(), genconstrs, newvals, 3, 4, 3);
    }

    public void prefetchAttr(GRB.IntAttr attr) throws GRBException {
        this.prefetchattr(attr.toString());
    }

    public void prefetchAttr(GRB.CharAttr attr) throws GRBException {
        this.prefetchattr(attr.toString());
    }

    public void prefetchAttr(GRB.DoubleAttr attr) throws GRBException {
        this.prefetchattr(attr.toString());
    }

    public void prefetchAttr(GRB.StringAttr attr) throws GRBException {
        this.prefetchattr(attr.toString());
    }

    private void fromjni() throws GRBException {
        this.cb.setandcall(this.model, this.cols, this.cbdata, this.where);
    }

    private native int jniunsetcallback(long var1);

    private native int jnioptimizebatch(long var1, String[] var3);

    private native int jnioptimize(long var1, int var3, int var4, long[] var5, String[] var6);

    private native int jnicomputeIIS(long var1, int var3, String[] var4);

    public void setCallback(GRBCallback cb) throws GRBException {
        int error;
        if (this.cb != null && (error = this.jniunsetcallback(this.model)) != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        this.cb = cb;
    }

    public void setLogCallback(Consumer<String> logCallback) throws GRBException {
        this.getEnv().setLogCallback(logCallback);
    }

    private void getattr(String attrname, Object o1, Object o2, int dim, int vorc, int type) throws GRBException {
        int[] ind;
        int error;
        if (vorc == 0) {
            error = GRB.checkattrsize(this.model, attrname, 1);
            if (error != 0) {
                throw new GRBException("Not right attribute", error);
            }
            ind = this.setvarsind(o1, dim);
        } else if (vorc == 1) {
            error = GRB.checkattrsize(this.model, attrname, 2);
            if (error != 0) {
                throw new GRBException("Not right attribute", error);
            }
            ind = this.setconstrsind(o1, dim);
        } else if (vorc == 3) {
            error = GRB.checkattrsize(this.model, attrname, 4);
            if (error != 0) {
                throw new GRBException("Not right attribute", error);
            }
            ind = this.setqconstrsind(o1, dim);
        } else if (vorc == 4) {
            error = GRB.checkattrsize(this.model, attrname, 5);
            if (error != 0) {
                throw new GRBException("Not right attribute", error);
            }
            ind = this.setgenconstrsind(o1, dim);
        } else {
            assert (false);
            return;
        }
        int len = ind.length;
        if (ind.length == 0) {
            return;
        }
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        if (type == 0) {
            int[] values = new int[len];
            int error2 = GurobiJni.getintattrlist(this.model, attrname, -1, len, ind, values);
            if (error2 != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error2);
            }
            this.setints(o2, dim, values);
        } else if (type == 1) {
            char[] values = new char[len];
            int error3 = GurobiJni.getcharattrlist(this.model, attrname, -1, len, ind, values);
            if (error3 != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error3);
            }
            this.setchars(o2, dim, values);
        } else if (type == 2) {
            double[] values = new double[len];
            int error4 = GurobiJni.getdblattrlist(this.model, attrname, -1, len, ind, values);
            if (error4 != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error4);
            }
            this.setdbls(o2, dim, values);
        } else {
            String[] values = new String[len];
            int error5 = GurobiJni.getstrattrlist(this.model, attrname, -1, len, ind, values);
            if (error5 != 0) {
                throw new GRBException(GurobiJni.geterrormsg(this.env), error5);
            }
            this.setstrs(o2, dim, values);
        }
    }

    public int FSolve(int blen, int[] bind, double[] bval, int[] xind, double[] xval) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        if (bind == null || bval == null || xind == null || xval == null) {
            throw new GRBException("Null arrays", 10002);
        }
        if (blen <= 0 || blen > this.rows || bind.length < blen || bval.length < blen || xind.length < this.rows || xval.length < this.rows) {
            throw new GRBException("Array too short or wrong length", 10003);
        }
        int[] xlen = new int[]{this.rows};
        int error = GurobiJni.fsolve(this.model, blen, bind, bval, xlen, xind, xval);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return xlen[0];
    }

    public int BinvColj(int col, int[] xind, double[] xval) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        if (col < 0 || col >= this.cols + this.rows) {
            throw new GRBException("Column not in the model", 20001);
        }
        if (xind == null || xval == null) {
            throw new GRBException("Null arrays", 10002);
        }
        if (xind.length < this.rows || xval.length < this.rows) {
            throw new GRBException("Array too short", 10003);
        }
        int[] xlen = new int[]{this.rows};
        int error = GurobiJni.binvcolj(this.model, col, xlen, xind, xval);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return xlen[0];
    }

    public int Binvj(int j, int[] xind, double[] xval) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        if (j < 0 || j >= this.rows) {
            throw new GRBException("Column not in the model", 20001);
        }
        if (xind == null || xval == null) {
            throw new GRBException("Null arrays", 10002);
        }
        if (xind.length < this.rows || xval.length < this.rows) {
            throw new GRBException("Array too short", 10003);
        }
        int[] bind = new int[1];
        double[] bval = new double[1];
        bind[0] = j;
        bval[0] = 1.0;
        int[] xlen = new int[]{this.rows};
        int error = GurobiJni.fsolve(this.model, 1, bind, bval, xlen, xind, xval);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return xlen[0];
    }

    public int BSolve(int blen, int[] bind, double[] bval, int[] xind, double[] xval) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        if (bind == null || bval == null || xind == null || xval == null) {
            throw new GRBException("Null arrays", 10002);
        }
        if (blen <= 0 || blen > this.rows || bind.length < blen || bval.length < blen || xind.length < this.rows || xval.length < this.rows) {
            throw new GRBException("Array too short or wrong length", 10003);
        }
        int[] xlen = new int[]{this.rows};
        int error = GurobiJni.bsolve(this.model, blen, bind, bval, xlen, xind, xval);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return xlen[0];
    }

    public int Binvi(int i, int[] xind, double[] xval) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        if (i < 0 || i >= this.rows) {
            throw new GRBException("Column not in the model", 20001);
        }
        if (xind == null || xval == null) {
            throw new GRBException("Null arrays", 10002);
        }
        if (xind.length < this.rows || xval.length < this.rows) {
            throw new GRBException("Array too short", 10003);
        }
        int[] bind = new int[1];
        double[] bval = new double[1];
        bind[0] = i;
        bval[0] = 1.0;
        int[] xlen = new int[]{this.rows};
        int error = GurobiJni.bsolve(this.model, 1, bind, bval, xlen, xind, xval);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return xlen[0];
    }

    public int BinvRowi(int i, int[] xind, double[] xval) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        if (i < 0 || i >= this.rows) {
            throw new GRBException("Column not in the model", 20001);
        }
        if (xind == null || xval == null) {
            throw new GRBException("Null arrays", 10002);
        }
        if (xind.length < this.cols + this.rows || xval.length < this.cols + this.rows) {
            throw new GRBException("Array too short", 10003);
        }
        int[] xlen = new int[]{this.cols + this.rows};
        int error = GurobiJni.binvrowi(this.model, i, xlen, xind, xval);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return xlen[0];
    }

    public void BasisHead(int[] bhead) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        if (bhead == null) {
            throw new GRBException("Null arrays", 10002);
        }
        if (bhead.length < this.rows) {
            throw new GRBException("Array too short", 10003);
        }
        bhead[0] = this.rows;
        int error = GurobiJni.basishead(this.model, bhead);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    private void setattr(String attrname, Object o1, Object o2, int dim, int vorc, int type) throws GRBException {
        int[] ind;
        int error = 0;
        if (vorc == 0) {
            error = GRB.checkattrsize(this.model, attrname, 1);
            if (error != 0) {
                throw new GRBException("Not right attribute", error);
            }
            ind = this.setvarsind(o1, dim);
        } else if (vorc == 1) {
            error = GRB.checkattrsize(this.model, attrname, 2);
            if (error != 0) {
                throw new GRBException("Not right attribute", error);
            }
            ind = this.setconstrsind(o1, dim);
        } else if (vorc == 3) {
            error = GRB.checkattrsize(this.model, attrname, 4);
            if (error != 0) {
                throw new GRBException("Not right attribute", error);
            }
            ind = this.setqconstrsind(o1, dim);
        } else if (vorc == 4) {
            error = GRB.checkattrsize(this.model, attrname, 5);
            if (error != 0) {
                throw new GRBException("Not right attribute", error);
            }
            ind = this.setgenconstrsind(o1, dim);
        } else {
            assert (false);
            return;
        }
        int len = ind.length;
        if (ind.length == 0) {
            return;
        }
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        if (type == 0) {
            int[] newvalues = new int[len];
            this.getints(o2, dim, newvalues);
            error = GurobiJni.setintattrlist(this.model, attrname, -1, len, ind, newvalues);
        } else if (type == 1) {
            char[] newvalues = new char[len];
            this.getchars(o2, dim, newvalues);
            error = GurobiJni.setcharattrlist(this.model, attrname, -1, len, ind, newvalues);
        } else if (type == 2) {
            double[] newvalues = new double[len];
            this.getdbls(o2, dim, newvalues);
            error = GurobiJni.setdblattrlist(this.model, attrname, -1, len, ind, newvalues);
        } else {
            String[] newvalues = new String[len];
            this.getstrs(o2, dim, newvalues);
            error = GurobiJni.setstrattrlist(this.model, attrname, -1, len, ind, newvalues);
        }
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    private void prefetchattr(String attrname) throws GRBException {
        if (this.model == 0L) {
            throw new GRBException("Model not loaded", 20003);
        }
        int error = GurobiJni.prefetchattr(this.model, attrname);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    private int[] setvarsind(Object o, int dim) throws GRBException {
        if (dim < 1 || dim > 3) {
            throw new GRBException("Incorrect dimensions", 10003);
        }
        int[] ind = null;
        int len = 0;
        switch (dim) {
            case 1: {
                GRBVar[] varr = (GRBVar[])o;
                int size = varr.length;
                ind = new int[size];
                for (int i1 = 0; i1 < varr.length; ++i1) {
                    int col = varr[i1].getcolno();
                    if (col < 0) {
                        throw new GRBException("Not in the model", 20001);
                    }
                    ind[len++] = col;
                }
                break;
            }
            case 2: {
                GRBVar[][] varr = (GRBVar[][])o;
                int size = varr.length * varr[0].length;
                ind = new int[size];
                for (int i1 = 0; i1 < varr.length; ++i1) {
                    for (int i2 = 0; i2 < varr[i1].length; ++i2) {
                        int col = varr[i1][i2].getcolno();
                        if (col < 0) {
                            throw new GRBException("Not in the model", 20001);
                        }
                        ind[len++] = col;
                    }
                }
                break;
            }
            case 3: {
                GRBVar[][][] varr = (GRBVar[][][])o;
                int size = varr.length * varr[0].length * varr[0][0].length;
                ind = new int[size];
                for (int i1 = 0; i1 < varr.length; ++i1) {
                    for (int i2 = 0; i2 < varr[i1].length; ++i2) {
                        for (int i3 = 0; i3 < varr[i1][i2].length; ++i3) {
                            int col = varr[i1][i2][i3].getcolno();
                            if (col < 0) {
                                throw new GRBException("Not in the model", 20001);
                            }
                            ind[len++] = col;
                        }
                    }
                }
                break;
            }
        }
        return ind;
    }

    private int[] setconstrsind(Object o, int dim) throws GRBException {
        if (dim < 1 || dim > 3) {
            throw new GRBException("Incorrect dimensions", 10003);
        }
        int[] ind = null;
        int len = 0;
        switch (dim) {
            case 1: {
                GRBConstr[] varr = (GRBConstr[])o;
                int size = varr.length;
                ind = new int[size];
                for (int i1 = 0; i1 < varr.length; ++i1) {
                    int col = varr[i1].getrowno();
                    if (col < 0) {
                        throw new GRBException("Not in the model", 20001);
                    }
                    ind[len++] = col;
                }
                break;
            }
            case 2: {
                GRBConstr[][] varr = (GRBConstr[][])o;
                int size = varr.length * varr[0].length;
                ind = new int[size];
                for (int i1 = 0; i1 < varr.length; ++i1) {
                    for (int i2 = 0; i2 < varr[i1].length; ++i2) {
                        int col = varr[i1][i2].getrowno();
                        if (col < 0) {
                            throw new GRBException("Not in the model", 20001);
                        }
                        ind[len++] = col;
                    }
                }
                break;
            }
            case 3: {
                GRBConstr[][][] varr = (GRBConstr[][][])o;
                int size = varr.length * varr[0].length * varr[0][0].length;
                ind = new int[size];
                for (int i1 = 0; i1 < varr.length; ++i1) {
                    for (int i2 = 0; i2 < varr[i1].length; ++i2) {
                        for (int i3 = 0; i3 < varr[i1][i2].length; ++i3) {
                            int col = varr[i1][i2][i3].getrowno();
                            if (col < 0) {
                                throw new GRBException("Not in the model", 20001);
                            }
                            ind[len++] = col;
                        }
                    }
                }
                break;
            }
        }
        return ind;
    }

    private int[] setqconstrsind(Object o, int dim) throws GRBException {
        if (dim < 1 || dim > 3) {
            throw new GRBException("Incorrect dimensions", 10003);
        }
        int[] ind = null;
        int len = 0;
        switch (dim) {
            case 1: {
                GRBQConstr[] varr = (GRBQConstr[])o;
                int size = varr.length;
                ind = new int[size];
                for (int i1 = 0; i1 < varr.length; ++i1) {
                    int col = varr[i1].getindex();
                    if (col < 0) {
                        throw new GRBException("Not in the model", 20001);
                    }
                    ind[len++] = col;
                }
                break;
            }
            case 2: {
                GRBQConstr[][] varr = (GRBQConstr[][])o;
                int size = varr.length * varr[0].length;
                ind = new int[size];
                for (int i1 = 0; i1 < varr.length; ++i1) {
                    for (int i2 = 0; i2 < varr[i1].length; ++i2) {
                        int col = varr[i1][i2].getindex();
                        if (col < 0) {
                            throw new GRBException("Not in the model", 20001);
                        }
                        ind[len++] = col;
                    }
                }
                break;
            }
            case 3: {
                GRBQConstr[][][] varr = (GRBQConstr[][][])o;
                int size = varr.length * varr[0].length * varr[0][0].length;
                ind = new int[size];
                for (int i1 = 0; i1 < varr.length; ++i1) {
                    for (int i2 = 0; i2 < varr[i1].length; ++i2) {
                        for (int i3 = 0; i3 < varr[i1][i2].length; ++i3) {
                            int col = varr[i1][i2][i3].getindex();
                            if (col < 0) {
                                throw new GRBException("Not in the model", 20001);
                            }
                            ind[len++] = col;
                        }
                    }
                }
                break;
            }
        }
        return ind;
    }

    private int[] setgenconstrsind(Object o, int dim) throws GRBException {
        if (dim < 1 || dim > 3) {
            throw new GRBException("Incorrect dimensions", 10003);
        }
        int[] ind = null;
        int len = 0;
        switch (dim) {
            case 1: {
                GRBGenConstr[] varr = (GRBGenConstr[])o;
                int size = varr.length;
                ind = new int[size];
                for (int i1 = 0; i1 < varr.length; ++i1) {
                    int col = varr[i1].getindex();
                    if (col < 0) {
                        throw new GRBException("Not in the model", 20001);
                    }
                    ind[len++] = col;
                }
                break;
            }
            case 2: {
                GRBGenConstr[][] varr = (GRBGenConstr[][])o;
                int size = varr.length * varr[0].length;
                ind = new int[size];
                for (int i1 = 0; i1 < varr.length; ++i1) {
                    for (int i2 = 0; i2 < varr[i1].length; ++i2) {
                        int col = varr[i1][i2].getindex();
                        if (col < 0) {
                            throw new GRBException("Not in the model", 20001);
                        }
                        ind[len++] = col;
                    }
                }
                break;
            }
            case 3: {
                GRBGenConstr[][][] varr = (GRBGenConstr[][][])o;
                int size = varr.length * varr[0].length * varr[0][0].length;
                ind = new int[size];
                for (int i1 = 0; i1 < varr.length; ++i1) {
                    for (int i2 = 0; i2 < varr[i1].length; ++i2) {
                        for (int i3 = 0; i3 < varr[i1][i2].length; ++i3) {
                            int col = varr[i1][i2][i3].getindex();
                            if (col < 0) {
                                throw new GRBException("Not in the model", 20001);
                            }
                            ind[len++] = col;
                        }
                    }
                }
                break;
            }
        }
        return ind;
    }

    private void setints(Object o, int dim, int[] values) {
        int len = 0;
        switch (dim) {
            case 1: {
                int[] val = (int[])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    val[i1] = values[len++];
                }
                break;
            }
            case 2: {
                int[][] val = (int[][])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    for (int i2 = 0; i2 < val[i1].length; ++i2) {
                        val[i1][i2] = values[len++];
                    }
                }
                break;
            }
            case 3: {
                int[][][] val = (int[][][])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    for (int i2 = 0; i2 < val[i1].length; ++i2) {
                        for (int i3 = 0; i3 < val[i1][i2].length; ++i3) {
                            val[i1][i2][i3] = values[len++];
                        }
                    }
                }
                break;
            }
        }
    }

    private void getints(Object o, int dim, int[] values) {
        int len = 0;
        switch (dim) {
            case 1: {
                int[] val = (int[])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    values[len++] = val[i1];
                }
                break;
            }
            case 2: {
                int[][] val = (int[][])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    for (int i2 = 0; i2 < val[i1].length; ++i2) {
                        values[len++] = val[i1][i2];
                    }
                }
                break;
            }
            case 3: {
                int[][][] val = (int[][][])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    for (int i2 = 0; i2 < val[i1].length; ++i2) {
                        for (int i3 = 0; i3 < val[i1][i2].length; ++i3) {
                            values[len++] = val[i1][i2][i3];
                        }
                    }
                }
                break;
            }
        }
    }

    private void setchars(Object o, int dim, char[] values) {
        int len = 0;
        switch (dim) {
            case 1: {
                char[] val = (char[])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    val[i1] = values[len++];
                }
                break;
            }
            case 2: {
                char[][] val = (char[][])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    for (int i2 = 0; i2 < val[i1].length; ++i2) {
                        val[i1][i2] = values[len++];
                    }
                }
                break;
            }
            case 3: {
                char[][][] val = (char[][][])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    for (int i2 = 0; i2 < val[i1].length; ++i2) {
                        for (int i3 = 0; i3 < val[i1][i2].length; ++i3) {
                            val[i1][i2][i3] = values[len++];
                        }
                    }
                }
                break;
            }
        }
    }

    private void getchars(Object o, int dim, char[] values) {
        int len = 0;
        switch (dim) {
            case 1: {
                char[] val = (char[])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    values[len++] = val[i1];
                }
                break;
            }
            case 2: {
                char[][] val = (char[][])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    for (int i2 = 0; i2 < val[i1].length; ++i2) {
                        values[len++] = val[i1][i2];
                    }
                }
                break;
            }
            case 3: {
                char[][][] val = (char[][][])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    for (int i2 = 0; i2 < val[i1].length; ++i2) {
                        for (int i3 = 0; i3 < val[i1][i2].length; ++i3) {
                            values[len++] = val[i1][i2][i3];
                        }
                    }
                }
                break;
            }
        }
    }

    private void setdbls(Object o, int dim, double[] values) {
        int len = 0;
        switch (dim) {
            case 1: {
                double[] val = (double[])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    val[i1] = values[len++];
                }
                break;
            }
            case 2: {
                double[][] val = (double[][])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    for (int i2 = 0; i2 < val[i1].length; ++i2) {
                        val[i1][i2] = values[len++];
                    }
                }
                break;
            }
            case 3: {
                double[][][] val = (double[][][])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    for (int i2 = 0; i2 < val[i1].length; ++i2) {
                        for (int i3 = 0; i3 < val[i1][i2].length; ++i3) {
                            val[i1][i2][i3] = values[len++];
                        }
                    }
                }
                break;
            }
        }
    }

    private void getdbls(Object o, int dim, double[] values) {
        int len = 0;
        switch (dim) {
            case 1: {
                double[] val = (double[])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    values[len++] = val[i1];
                }
                break;
            }
            case 2: {
                double[][] val = (double[][])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    for (int i2 = 0; i2 < val[i1].length; ++i2) {
                        values[len++] = val[i1][i2];
                    }
                }
                break;
            }
            case 3: {
                double[][][] val = (double[][][])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    for (int i2 = 0; i2 < val[i1].length; ++i2) {
                        for (int i3 = 0; i3 < val[i1][i2].length; ++i3) {
                            values[len++] = val[i1][i2][i3];
                        }
                    }
                }
                break;
            }
        }
    }

    private void setstrs(Object o, int dim, String[] values) {
        int len = 0;
        switch (dim) {
            case 1: {
                String[] val = (String[])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    val[i1] = values[len++];
                }
                break;
            }
            case 2: {
                String[][] val = (String[][])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    for (int i2 = 0; i2 < val[i1].length; ++i2) {
                        val[i1][i2] = values[len++];
                    }
                }
                break;
            }
            case 3: {
                String[][][] val = (String[][][])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    for (int i2 = 0; i2 < val[i1].length; ++i2) {
                        for (int i3 = 0; i3 < val[i1][i2].length; ++i3) {
                            val[i1][i2][i3] = values[len++];
                        }
                    }
                }
                break;
            }
        }
    }

    private void getstrs(Object o, int dim, String[] values) {
        int len = 0;
        switch (dim) {
            case 1: {
                String[] val = (String[])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    values[len++] = val[i1];
                }
                break;
            }
            case 2: {
                String[][] val = (String[][])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    for (int i2 = 0; i2 < val[i1].length; ++i2) {
                        values[len++] = val[i1][i2];
                    }
                }
                break;
            }
            case 3: {
                String[][][] val = (String[][][])o;
                for (int i1 = 0; i1 < val.length; ++i1) {
                    for (int i2 = 0; i2 < val[i1].length; ++i2) {
                        for (int i3 = 0; i3 < val[i1][i2].length; ++i3) {
                            values[len++] = val[i1][i2][i3];
                        }
                    }
                }
                break;
            }
        }
    }

    private int checkdim2(Object[][] o) {
        if (o == null || o.length == 0 || o[0].length == 0) {
            return 1;
        }
        int len = o[0].length;
        for (int i = 1; i < o.length; ++i) {
            if (o[i].length == len) continue;
            return 2;
        }
        return 0;
    }

    private int checkdim3(Object[][][] o) {
        if (o == null || o.length == 0 || o[0].length == 0 || o[0][0].length == 0) {
            return 1;
        }
        int len1 = o[0].length;
        int len2 = o[0][0].length;
        for (int i = 0; i < o.length; ++i) {
            if (o[i].length != len1) {
                return 1;
            }
            for (int j = 1; j < len1; ++j) {
                if (o[i][j].length == len2) continue;
                return 1;
            }
        }
        return 0;
    }

    private int checkdim2(int[][] o) {
        if (o == null || o.length == 0 || o[0].length == 0) {
            return 1;
        }
        int len = o[0].length;
        for (int i = 1; i < o.length; ++i) {
            if (o[i].length == len) continue;
            return 2;
        }
        return 0;
    }

    private int checkdim3(int[][][] o) {
        if (o == null || o.length == 0 || o[0].length == 0 || o[0][0].length == 0) {
            return 1;
        }
        int len1 = o[0].length;
        int len2 = o[0][0].length;
        for (int i = 0; i < o.length; ++i) {
            if (o[i].length != len1) {
                return 1;
            }
            for (int j = 1; j < len1; ++j) {
                if (o[i][j].length == len2) continue;
                return 1;
            }
        }
        return 0;
    }

    private int checkdim2(char[][] o) {
        if (o == null || o.length == 0 || o[0].length == 0) {
            return 1;
        }
        int len = o[0].length;
        for (int i = 1; i < o.length; ++i) {
            if (o[i].length == len) continue;
            return 2;
        }
        return 0;
    }

    private int checkdim3(char[][][] o) {
        if (o == null || o.length == 0 || o[0].length == 0 || o[0][0].length == 0) {
            return 1;
        }
        int len1 = o[0].length;
        int len2 = o[0][0].length;
        for (int i = 0; i < o.length; ++i) {
            if (o[i].length != len1) {
                return 1;
            }
            for (int j = 1; j < len1; ++j) {
                if (o[i][j].length == len2) continue;
                return 1;
            }
        }
        return 0;
    }

    private int checkdim2(double[][] o) {
        if (o == null || o.length == 0 || o[0].length == 0) {
            return 1;
        }
        int len = o[0].length;
        for (int i = 1; i < o.length; ++i) {
            if (o[i].length == len) continue;
            return 2;
        }
        return 0;
    }

    private int checkdim3(double[][][] o) {
        if (o == null || o.length == 0 || o[0].length == 0 || o[0][0].length == 0) {
            return 1;
        }
        int len1 = o[0].length;
        int len2 = o[0][0].length;
        for (int i = 0; i < o.length; ++i) {
            if (o[i].length != len1) {
                return 1;
            }
            for (int j = 1; j < len1; ++j) {
                if (o[i][j].length == len2) continue;
                return 1;
            }
        }
        return 0;
    }

    private boolean samedim2(Object[][] o, Object[][] o1) {
        return o.length == o1.length && o[0].length == o1[0].length;
    }

    private boolean samedim3(Object[][][] o, Object[][][] o1) {
        return o.length == o1.length && o[0].length == o1[0].length && o[0][0].length == o1[0][0].length;
    }

    private boolean samedim2(Object[][] o, int[][] o1) {
        return o.length == o1.length && o[0].length == o1[0].length;
    }

    private boolean samedim3(Object[][][] o, int[][][] o1) {
        return o.length == o1.length && o[0].length == o1[0].length && o[0][0].length == o1[0][0].length;
    }

    private boolean samedim2(Object[][] o, char[][] o1) {
        return o.length == o1.length && o[0].length == o1[0].length;
    }

    private boolean samedim3(Object[][][] o, char[][][] o1) {
        return o.length == o1.length && o[0].length == o1[0].length && o[0][0].length == o1[0][0].length;
    }

    private boolean samedim2(Object[][] o, double[][] o1) {
        return o.length == o1.length && o[0].length == o1[0].length;
    }

    private boolean samedim3(Object[][][] o, double[][][] o1) {
        return o.length == o1.length && o[0].length == o1[0].length && o[0][0].length == o1[0][0].length;
    }

    private GRBVar[] subArray(GRBVar[] o, int start, int len) throws GRBException {
        int last = start + len;
        if (start < 0 || last > o.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        GRBVar[] o1 = new GRBVar[len];
        for (int i = 0; i < len; ++i) {
            o1[i] = o[i + start];
        }
        return o1;
    }

    private GRBConstr[] subArray(GRBConstr[] o, int start, int len) throws GRBException {
        int last = start + len;
        if (start < 0 || last > o.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        GRBConstr[] o1 = new GRBConstr[len];
        for (int i = 0; i < len; ++i) {
            o1[i] = o[i + start];
        }
        return o1;
    }

    private GRBQConstr[] subArray(GRBQConstr[] o, int start, int len) throws GRBException {
        int last = start + len;
        if (start < 0 || last > o.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        GRBQConstr[] o1 = new GRBQConstr[len];
        for (int i = 0; i < len; ++i) {
            o1[i] = o[i + start];
        }
        return o1;
    }

    private GRBGenConstr[] subArray(GRBGenConstr[] o, int start, int len) throws GRBException {
        int last = start + len;
        if (start < 0 || last > o.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        GRBGenConstr[] o1 = new GRBGenConstr[len];
        for (int i = 0; i < len; ++i) {
            o1[i] = o[i + start];
        }
        return o1;
    }

    private String[] subArray(String[] o, int start, int len) throws GRBException {
        int last = start + len;
        if (start < 0 || last > o.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        String[] o1 = new String[len];
        for (int i = 0; i < len; ++i) {
            o1[i] = o[i + start];
        }
        return o1;
    }

    private int[] subArray(int[] o, int start, int len) throws GRBException {
        int last = start + len;
        if (start < 0 || last > o.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        int[] o1 = new int[len];
        for (int i = 0; i < len; ++i) {
            o1[i] = o[i + start];
        }
        return o1;
    }

    private char[] subArray(char[] o, int start, int len) throws GRBException {
        int last = start + len;
        if (start < 0 || last > o.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        char[] o1 = new char[len];
        for (int i = 0; i < len; ++i) {
            o1[i] = o[i + start];
        }
        return o1;
    }

    private double[] subArray(double[] o, int start, int len) throws GRBException {
        int last = start + len;
        if (start < 0 || last > o.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        double[] o1 = new double[len];
        for (int i = 0; i < len; ++i) {
            o1[i] = o[i + start];
        }
        return o1;
    }

    private int getupdmode() throws GRBException {
        if (this.updatemode == -1) {
            this.updatemode = this.getEnv().get(GRB.IntParam.UpdateMode);
        }
        return this.updatemode;
    }
}

