/*
 * Decompiled with CFR 0.152.
 */
package gurobi;

import gurobi.GRB;
import gurobi.GRBException;
import gurobi.GurobiJni;
import java.util.function.Consumer;

public class GRBEnv {
    private long env = 0L;
    private volatile int modcnt = 0;
    private boolean needfree = true;
    private Consumer<String> logCB = null;
    private String logmsg = null;

    public GRBEnv() throws GRBException {
        this(null);
    }

    public GRBEnv(String logFileName) throws GRBException {
        long[] jenv = new long[1];
        int error = GurobiJni.loadenv(jenv, logFileName, 10, 0, 3, -1);
        this.env = jenv[0];
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public GRBEnv(boolean empty) throws GRBException {
        long[] jenv = new long[1];
        int error = empty ? GurobiJni.createenv(jenv, 10, 0, 3) : GurobiJni.loadenv(jenv, "", 10, 0, 3, -1);
        this.env = jenv[0];
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public GRBEnv(String s0, String s1, String s2, int i1, String s3) throws GRBException {
        long[] jenv = new long[1];
        int error = GurobiJni.isqp(jenv, s0, s1, s2, i1, s3);
        this.env = jenv[0];
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public GRBEnv(String s0, String s1, String s2) throws GRBException {
        long[] jenv = new long[1];
        int error = GurobiJni.isqp(jenv, s0, s1, s2, 0, "");
        this.env = jenv[0];
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    GRBEnv(long cenv) {
        this.env = cenv;
        this.needfree = false;
    }

    public void start() throws GRBException {
        int error = GurobiJni.startenv(this.env);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void release() {
        GurobiJni.releaselicense(this.env);
    }

    public void dispose() throws GRBException {
        if (this.needfree && this.modelCntZero()) {
            this.needfree = false;
            GurobiJni.freeenv(this.env);
        }
    }

    protected void finalize() throws GRBException {
        if (this.needfree && this.modelCntZero()) {
            this.needfree = false;
            GurobiJni.freeenv(this.env);
        }
    }

    long get() {
        return this.env;
    }

    public int getWLSTokenLifespan() throws GRBException {
        int[] value = new int[1];
        int error = GurobiJni.getwlstokenlifespan(this.env, value);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return value[0];
    }

    private void jniPrintLog() {
        if (this.logCB != null) {
            this.logCB.accept(this.logmsg);
        }
    }

    private native int jniSetLogCB(long var1, int var3);

    public void setLogCallback(Consumer<String> logCallback) {
        this.logCB = logCallback;
        if (logCallback == null) {
            this.jniSetLogCB(this.env, 0);
        } else {
            this.jniSetLogCB(this.env, 1);
        }
    }

    public void message(String message) throws GRBException {
        int error = GurobiJni.message(this.env, message);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public int get(GRB.IntParam param) throws GRBException {
        int[] value = new int[1];
        int error = GurobiJni.getintparam(this.env, param.toString(), value);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return value[0];
    }

    public double get(GRB.DoubleParam param) throws GRBException {
        double[] value = new double[1];
        int error = GurobiJni.getdblparam(this.env, param.toString(), value);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return value[0];
    }

    public String get(GRB.StringParam param) throws GRBException {
        String[] value = new String[1];
        int error = GurobiJni.getstrparam(this.env, param.toString(), value);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return value[0];
    }

    public void fixTuneParam(GRB.IntParam param) throws GRBException {
        this.fixTuneParam(param.toString());
    }

    public void fixTuneParam(GRB.DoubleParam param) throws GRBException {
        this.fixTuneParam(param.toString());
    }

    public void fixTuneParam(GRB.StringParam param) throws GRBException {
        this.fixTuneParam(param.toString());
    }

    public void fixTuneParam(String param) throws GRBException {
        int error = GurobiJni.fixtuneparam(this.env, param);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void set(GRB.IntParam param, int newval) throws GRBException {
        int error = GurobiJni.setintparam(this.env, param.toString(), newval);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void set(GRB.DoubleParam param, double newval) throws GRBException {
        int error = GurobiJni.setdblparam(this.env, param.toString(), newval);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void set(GRB.StringParam param, String newval) throws GRBException {
        int error = GurobiJni.setstrparam(this.env, param.toString(), newval);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void set(String param, String newval) throws GRBException {
        int error = GurobiJni.setparam(this.env, param, newval);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void getParamInfo(GRB.IntParam param, int[] info) throws GRBException {
        int error = GurobiJni.getintparaminfo(this.env, param.toString(), info);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void getParamInfo(GRB.DoubleParam param, double[] info) throws GRBException {
        int error = GurobiJni.getdblparaminfo(this.env, param.toString(), info);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void getParamInfo(GRB.StringParam param, String[] info) throws GRBException {
        int error = GurobiJni.getstrparaminfo(this.env, param.toString(), info);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void resetParams() throws GRBException {
        int error = GurobiJni.resetparams(this.env);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void writeParams(String paramFile) throws GRBException {
        int error = GurobiJni.writeparams(this.env, paramFile);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void readParams(String paramFile) throws GRBException {
        int error = GurobiJni.readparams(this.env, paramFile);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public String getErrorMsg() {
        return GurobiJni.geterrormsg(this.env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modelCntIncrease() {
        GRBEnv gRBEnv = this;
        synchronized (gRBEnv) {
            ++this.modcnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modelCntDecrease() {
        GRBEnv gRBEnv = this;
        synchronized (gRBEnv) {
            --this.modcnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean modelCntZero() {
        GRBEnv gRBEnv = this;
        synchronized (gRBEnv) {
            return this.modcnt == 0;
            {
            }
        }
    }
}

