/*
 * Decompiled with CFR 0.152.
 */
package gurobi;

import gurobi.GRB;
import gurobi.GRBEnv;
import gurobi.GRBException;
import gurobi.GurobiJni;

public class GRBBatch {
    private GRBEnv genv = null;
    private long env = 0L;
    private long batch = 0L;
    private int isfreed = 0;

    private native int getintattr(long var1, String var3, int[] var4);

    private native int getstrattr(long var1, String var3, String[] var4);

    private native int jniabort(long var1);

    private native int jnidiscard(long var1);

    private native int jnigetjsonsolution(long var1, String[] var3);

    private native int jniretry(long var1);

    private native int jniupdate(long var1);

    private native int jniwritejsonsolution(long var1, String var3);

    public void writeJSONSolution(String filename) throws GRBException {
        int error = this.jniwritejsonsolution(this.batch, filename);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public String getJSONSolution() throws GRBException {
        String[] val = new String[1];
        int error = this.jnigetjsonsolution(this.batch, val);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return val[0];
    }

    public void update() throws GRBException {
        int error = this.jniupdate(this.batch);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void abort() throws GRBException {
        int error = this.jniabort(this.batch);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void retry() throws GRBException {
        int error = this.jniretry(this.batch);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public void discard() throws GRBException {
        int error = this.jnidiscard(this.batch);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
    }

    public GRBBatch(GRBEnv env, String batchID) throws GRBException {
        this.genv = env;
        this.env = env.get();
        long[] jbatch = new long[1];
        int error = GurobiJni.newbatch(jbatch, this.env, batchID);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), 10003);
        }
        this.batch = jbatch[0];
        this.genv.modelCntIncrease();
    }

    long get() {
        return this.batch;
    }

    public void dispose() {
        if (this.isfreed == 0) {
            this.isfreed = 1;
            GurobiJni.freebatch(this.batch);
            this.batch = 0L;
            this.genv.modelCntDecrease();
        }
    }

    protected void finalize() {
        this.dispose();
    }

    public int get(GRB.IntAttr attr) throws GRBException {
        if (this.batch == 0L) {
            throw new GRBException("Invalid Batch Object", 20003);
        }
        int[] val = new int[1];
        int error = this.getintattr(this.batch, attr.name(), val);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return val[0];
    }

    public String get(GRB.StringAttr attr) throws GRBException {
        if (this.batch == 0L) {
            throw new GRBException("Invalid Batch Object", 20003);
        }
        String[] val = new String[1];
        int error = this.getstrattr(this.batch, attr.name(), val);
        if (error != 0) {
            throw new GRBException(GurobiJni.geterrormsg(this.env), error);
        }
        return val[0];
    }
}

